<?php
// This file was auto-generated from sdk-root/src/data/entityresolution/2018-05-10/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2018-05-10', 'endpointPrefix' => 'entityresolution', 'jsonVersion' => '1.1', 'protocol' => 'rest-json', 'serviceAbbreviation' => 'AWSEntityResolution', 'serviceFullName' => 'AWS EntityResolution', 'serviceId' => 'EntityResolution', 'signatureVersion' => 'v4', 'signingName' => 'entityresolution', 'uid' => 'entityresolution-2018-05-10', ], 'operations' => [ 'CreateMatchingWorkflow' => [ 'name' => 'CreateMatchingWorkflow', 'http' => [ 'method' => 'POST', 'requestUri' => '/matchingworkflows', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateMatchingWorkflowInput', ], 'output' => [ 'shape' => 'CreateMatchingWorkflowOutput', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ExceedsLimitException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], ], ], 'CreateSchemaMapping' => [ 'name' => 'CreateSchemaMapping', 'http' => [ 'method' => 'POST', 'requestUri' => '/schemas', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateSchemaMappingInput', ], 'output' => [ 'shape' => 'CreateSchemaMappingOutput', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ExceedsLimitException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], ], ], 'DeleteMatchingWorkflow' => [ 'name' => 'DeleteMatchingWorkflow', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/matchingworkflows/{workflowName}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteMatchingWorkflowInput', ], 'output' => [ 'shape' => 'DeleteMatchingWorkflowOutput', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], 'DeleteSchemaMapping' => [ 'name' => 'DeleteSchemaMapping', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/schemas/{schemaName}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteSchemaMappingInput', ], 'output' => [ 'shape' => 'DeleteSchemaMappingOutput', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], 'GetMatchId' => [ 'name' => 'GetMatchId', 'http' => [ 'method' => 'POST', 'requestUri' => '/matchingworkflows/{workflowName}/matches', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetMatchIdInput', ], 'output' => [ 'shape' => 'GetMatchIdOutput', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], ], ], 'GetMatchingJob' => [ 'name' => 'GetMatchingJob', 'http' => [ 'method' => 'GET', 'requestUri' => '/matchingworkflows/{workflowName}/jobs/{jobId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetMatchingJobInput', ], 'output' => [ 'shape' => 'GetMatchingJobOutput', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], ], ], 'GetMatchingWorkflow' => [ 'name' => 'GetMatchingWorkflow', 'http' => [ 'method' => 'GET', 'requestUri' => '/matchingworkflows/{workflowName}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetMatchingWorkflowInput', ], 'output' => [ 'shape' => 'GetMatchingWorkflowOutput', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], ], ], 'GetSchemaMapping' => [ 'name' => 'GetSchemaMapping', 'http' => [ 'method' => 'GET', 'requestUri' => '/schemas/{schemaName}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetSchemaMappingInput', ], 'output' => [ 'shape' => 'GetSchemaMappingOutput', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], ], ], 'ListMatchingJobs' => [ 'name' => 'ListMatchingJobs', 'http' => [ 'method' => 'GET', 'requestUri' => '/matchingworkflows/{workflowName}/jobs', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListMatchingJobsInput', ], 'output' => [ 'shape' => 'ListMatchingJobsOutput', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], ], ], 'ListMatchingWorkflows' => [ 'name' => 'ListMatchingWorkflows', 'http' => [ 'method' => 'GET', 'requestUri' => '/matchingworkflows', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListMatchingWorkflowsInput', ], 'output' => [ 'shape' => 'ListMatchingWorkflowsOutput', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], ], ], 'ListSchemaMappings' => [ 'name' => 'ListSchemaMappings', 'http' => [ 'method' => 'GET', 'requestUri' => '/schemas', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListSchemaMappingsInput', ], 'output' => [ 'shape' => 'ListSchemaMappingsOutput', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], ], ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'GET', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListTagsForResourceInput', ], 'output' => [ 'shape' => 'ListTagsForResourceOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], ], ], 'StartMatchingJob' => [ 'name' => 'StartMatchingJob', 'http' => [ 'method' => 'POST', 'requestUri' => '/matchingworkflows/{workflowName}/jobs', 'responseCode' => 200, ], 'input' => [ 'shape' => 'StartMatchingJobInput', ], 'output' => [ 'shape' => 'StartMatchingJobOutput', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ExceedsLimitException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], ], ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'TagResourceInput', ], 'output' => [ 'shape' => 'TagResourceOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], ], ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UntagResourceInput', ], 'output' => [ 'shape' => 'UntagResourceOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'UpdateMatchingWorkflow' => [ 'name' => 'UpdateMatchingWorkflow', 'http' => [ 'method' => 'PUT', 'requestUri' => '/matchingworkflows/{workflowName}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateMatchingWorkflowInput', ], 'output' => [ 'shape' => 'UpdateMatchingWorkflowOutput', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], ], 'idempotent' => true, ], ], 'shapes' => [ 'AccessDeniedException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 403, 'senderFault' => true, ], 'exception' => true, ], 'AttributeMatchingModel' => [ 'type' => 'string', 'enum' => [ 'ONE_TO_ONE', 'MANY_TO_MANY', ], ], 'AttributeName' => [ 'type' => 'string', 'max' => 255, 'min' => 0, 'pattern' => '^[a-zA-Z_0-9- \\t]*$', ], 'Boolean' => [ 'type' => 'boolean', 'box' => true, ], 'ConflictException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'CreateMatchingWorkflowInput' => [ 'type' => 'structure', 'required' => [ 'inputSourceConfig', 'outputSourceConfig', 'resolutionTechniques', 'roleArn', 'workflowName', ], 'members' => [ 'description' => [ 'shape' => 'Description', ], 'incrementalRunConfig' => [ 'shape' => 'IncrementalRunConfig', ], 'inputSourceConfig' => [ 'shape' => 'InputSourceConfig', ], 'outputSourceConfig' => [ 'shape' => 'OutputSourceConfig', ], 'resolutionTechniques' => [ 'shape' => 'ResolutionTechniques', ], 'roleArn' => [ 'shape' => 'String', ], 'tags' => [ 'shape' => 'TagMap', ], 'workflowName' => [ 'shape' => 'EntityName', ], ], ], 'CreateMatchingWorkflowOutput' => [ 'type' => 'structure', 'required' => [ 'inputSourceConfig', 'outputSourceConfig', 'resolutionTechniques', 'roleArn', 'workflowArn', 'workflowName', ], 'members' => [ 'description' => [ 'shape' => 'Description', ], 'incrementalRunConfig' => [ 'shape' => 'IncrementalRunConfig', ], 'inputSourceConfig' => [ 'shape' => 'InputSourceConfig', ], 'outputSourceConfig' => [ 'shape' => 'OutputSourceConfig', ], 'resolutionTechniques' => [ 'shape' => 'ResolutionTechniques', ], 'roleArn' => [ 'shape' => 'String', ], 'workflowArn' => [ 'shape' => 'MatchingWorkflowArn', ], 'workflowName' => [ 'shape' => 'EntityName', ], ], ], 'CreateSchemaMappingInput' => [ 'type' => 'structure', 'required' => [ 'schemaName', ], 'members' => [ 'description' => [ 'shape' => 'Description', ], 'mappedInputFields' => [ 'shape' => 'SchemaInputAttributes', ], 'schemaName' => [ 'shape' => 'EntityName', ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'CreateSchemaMappingOutput' => [ 'type' => 'structure', 'required' => [ 'description', 'mappedInputFields', 'schemaArn', 'schemaName', ], 'members' => [ 'description' => [ 'shape' => 'Description', ], 'mappedInputFields' => [ 'shape' => 'SchemaInputAttributes', ], 'schemaArn' => [ 'shape' => 'SchemaMappingArn', ], 'schemaName' => [ 'shape' => 'EntityName', ], ], ], 'DeleteMatchingWorkflowInput' => [ 'type' => 'structure', 'required' => [ 'workflowName', ], 'members' => [ 'workflowName' => [ 'shape' => 'EntityName', 'location' => 'uri', 'locationName' => 'workflowName', ], ], ], 'DeleteMatchingWorkflowOutput' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], ], 'DeleteSchemaMappingInput' => [ 'type' => 'structure', 'required' => [ 'schemaName', ], 'members' => [ 'schemaName' => [ 'shape' => 'EntityName', 'location' => 'uri', 'locationName' => 'schemaName', ], ], ], 'DeleteSchemaMappingOutput' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], ], 'Description' => [ 'type' => 'string', 'max' => 255, 'min' => 0, ], 'EntityName' => [ 'type' => 'string', 'max' => 255, 'min' => 0, 'pattern' => '^[a-zA-Z_0-9-]*$', ], 'ErrorDetails' => [ 'type' => 'structure', 'members' => [ 'errorMessage' => [ 'shape' => 'ErrorMessage', ], ], ], 'ErrorMessage' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, ], 'ExceedsLimitException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 402, 'senderFault' => true, ], 'exception' => true, ], 'GetMatchIdInput' => [ 'type' => 'structure', 'required' => [ 'record', 'workflowName', ], 'members' => [ 'record' => [ 'shape' => 'RecordAttributeMap', ], 'workflowName' => [ 'shape' => 'EntityName', 'location' => 'uri', 'locationName' => 'workflowName', ], ], ], 'GetMatchIdOutput' => [ 'type' => 'structure', 'members' => [ 'matchId' => [ 'shape' => 'String', ], ], ], 'GetMatchingJobInput' => [ 'type' => 'structure', 'required' => [ 'jobId', 'workflowName', ], 'members' => [ 'jobId' => [ 'shape' => 'JobId', 'location' => 'uri', 'locationName' => 'jobId', ], 'workflowName' => [ 'shape' => 'EntityName', 'location' => 'uri', 'locationName' => 'workflowName', ], ], ], 'GetMatchingJobOutput' => [ 'type' => 'structure', 'required' => [ 'jobId', 'startTime', 'status', ], 'members' => [ 'endTime' => [ 'shape' => 'Timestamp', ], 'errorDetails' => [ 'shape' => 'ErrorDetails', ], 'jobId' => [ 'shape' => 'JobId', ], 'metrics' => [ 'shape' => 'JobMetrics', ], 'startTime' => [ 'shape' => 'Timestamp', ], 'status' => [ 'shape' => 'JobStatus', ], ], ], 'GetMatchingWorkflowInput' => [ 'type' => 'structure', 'required' => [ 'workflowName', ], 'members' => [ 'workflowName' => [ 'shape' => 'EntityName', 'location' => 'uri', 'locationName' => 'workflowName', ], ], ], 'GetMatchingWorkflowOutput' => [ 'type' => 'structure', 'required' => [ 'createdAt', 'inputSourceConfig', 'outputSourceConfig', 'resolutionTechniques', 'roleArn', 'updatedAt', 'workflowArn', 'workflowName', ], 'members' => [ 'createdAt' => [ 'shape' => 'Timestamp', ], 'description' => [ 'shape' => 'Description', ], 'incrementalRunConfig' => [ 'shape' => 'IncrementalRunConfig', ], 'inputSourceConfig' => [ 'shape' => 'InputSourceConfig', ], 'outputSourceConfig' => [ 'shape' => 'OutputSourceConfig', ], 'resolutionTechniques' => [ 'shape' => 'ResolutionTechniques', ], 'roleArn' => [ 'shape' => 'String', ], 'tags' => [ 'shape' => 'TagMap', ], 'updatedAt' => [ 'shape' => 'Timestamp', ], 'workflowArn' => [ 'shape' => 'MatchingWorkflowArn', ], 'workflowName' => [ 'shape' => 'EntityName', ], ], ], 'GetSchemaMappingInput' => [ 'type' => 'structure', 'required' => [ 'schemaName', ], 'members' => [ 'schemaName' => [ 'shape' => 'EntityName', 'location' => 'uri', 'locationName' => 'schemaName', ], ], ], 'GetSchemaMappingOutput' => [ 'type' => 'structure', 'required' => [ 'createdAt', 'mappedInputFields', 'schemaArn', 'schemaName', 'updatedAt', ], 'members' => [ 'createdAt' => [ 'shape' => 'Timestamp', ], 'description' => [ 'shape' => 'Description', ], 'mappedInputFields' => [ 'shape' => 'SchemaInputAttributes', ], 'schemaArn' => [ 'shape' => 'SchemaMappingArn', ], 'schemaName' => [ 'shape' => 'EntityName', ], 'tags' => [ 'shape' => 'TagMap', ], 'updatedAt' => [ 'shape' => 'Timestamp', ], ], ], 'IncrementalRunConfig' => [ 'type' => 'structure', 'members' => [ 'incrementalRunType' => [ 'shape' => 'IncrementalRunType', ], ], ], 'IncrementalRunType' => [ 'type' => 'string', 'enum' => [ 'IMMEDIATE', ], ], 'InputSource' => [ 'type' => 'structure', 'required' => [ 'inputSourceARN', 'schemaName', ], 'members' => [ 'applyNormalization' => [ 'shape' => 'Boolean', ], 'inputSourceARN' => [ 'shape' => 'InputSourceInputSourceARNString', ], 'schemaName' => [ 'shape' => 'EntityName', ], ], ], 'InputSourceConfig' => [ 'type' => 'list', 'member' => [ 'shape' => 'InputSource', ], 'max' => 20, 'min' => 1, ], 'InputSourceInputSourceARNString' => [ 'type' => 'string', 'pattern' => '^arn:aws:.*:.*:[0-9]+:.*$', ], 'Integer' => [ 'type' => 'integer', 'box' => true, ], 'InternalServerException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 500, ], 'exception' => true, 'fault' => true, 'retryable' => [ 'throttling' => false, ], ], 'JobId' => [ 'type' => 'string', 'pattern' => '^[a-f0-9]{32}$', ], 'JobList' => [ 'type' => 'list', 'member' => [ 'shape' => 'JobSummary', ], ], 'JobMetrics' => [ 'type' => 'structure', 'members' => [ 'inputRecords' => [ 'shape' => 'Integer', ], 'matchIDs' => [ 'shape' => 'Integer', ], 'recordsNotProcessed' => [ 'shape' => 'Integer', ], 'totalRecordsProcessed' => [ 'shape' => 'Integer', ], ], ], 'JobStatus' => [ 'type' => 'string', 'enum' => [ 'RUNNING', 'SUCCEEDED', 'FAILED', 'QUEUED', ], ], 'JobSummary' => [ 'type' => 'structure', 'required' => [ 'jobId', 'startTime', 'status', ], 'members' => [ 'endTime' => [ 'shape' => 'Timestamp', ], 'jobId' => [ 'shape' => 'JobId', ], 'startTime' => [ 'shape' => 'Timestamp', ], 'status' => [ 'shape' => 'JobStatus', ], ], ], 'KMSArn' => [ 'type' => 'string', 'pattern' => '^arn:aws:kms:.*:[0-9]+:.*$', ], 'ListMatchingJobsInput' => [ 'type' => 'structure', 'required' => [ 'workflowName', ], 'members' => [ 'maxResults' => [ 'shape' => 'ListMatchingJobsInputMaxResultsInteger', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'workflowName' => [ 'shape' => 'EntityName', 'location' => 'uri', 'locationName' => 'workflowName', ], ], ], 'ListMatchingJobsInputMaxResultsInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 25, 'min' => 1, ], 'ListMatchingJobsOutput' => [ 'type' => 'structure', 'members' => [ 'jobs' => [ 'shape' => 'JobList', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListMatchingWorkflowsInput' => [ 'type' => 'structure', 'members' => [ 'maxResults' => [ 'shape' => 'ListMatchingWorkflowsInputMaxResultsInteger', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListMatchingWorkflowsInputMaxResultsInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 25, ], 'ListMatchingWorkflowsOutput' => [ 'type' => 'structure', 'members' => [ 'nextToken' => [ 'shape' => 'NextToken', ], 'workflowSummaries' => [ 'shape' => 'MatchingWorkflowList', ], ], ], 'ListSchemaMappingsInput' => [ 'type' => 'structure', 'members' => [ 'maxResults' => [ 'shape' => 'ListSchemaMappingsInputMaxResultsInteger', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListSchemaMappingsInputMaxResultsInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 25, ], 'ListSchemaMappingsOutput' => [ 'type' => 'structure', 'members' => [ 'nextToken' => [ 'shape' => 'NextToken', ], 'schemaList' => [ 'shape' => 'SchemaMappingList', ], ], ], 'ListTagsForResourceInput' => [ 'type' => 'structure', 'required' => [ 'resourceArn', ], 'members' => [ 'resourceArn' => [ 'shape' => 'VeniceGlobalArn', 'location' => 'uri', 'locationName' => 'resourceArn', ], ], ], 'ListTagsForResourceOutput' => [ 'type' => 'structure', 'required' => [ 'tags', ], 'members' => [ 'tags' => [ 'shape' => 'TagMap', ], ], ], 'MatchingWorkflowArn' => [ 'type' => 'string', 'pattern' => '^arn:(aws|aws-us-gov|aws-cn):entityresolution:.*:[0-9]+:(matchingworkflow/.*)$', ], 'MatchingWorkflowList' => [ 'type' => 'list', 'member' => [ 'shape' => 'MatchingWorkflowSummary', ], ], 'MatchingWorkflowSummary' => [ 'type' => 'structure', 'required' => [ 'createdAt', 'updatedAt', 'workflowArn', 'workflowName', ], 'members' => [ 'createdAt' => [ 'shape' => 'Timestamp', ], 'updatedAt' => [ 'shape' => 'Timestamp', ], 'workflowArn' => [ 'shape' => 'MatchingWorkflowArn', ], 'workflowName' => [ 'shape' => 'EntityName', ], ], ], 'NextToken' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, 'pattern' => '^[a-zA-Z_0-9-=+/]*$', ], 'OutputAttribute' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'hashed' => [ 'shape' => 'Boolean', ], 'name' => [ 'shape' => 'AttributeName', ], ], ], 'OutputSource' => [ 'type' => 'structure', 'required' => [ 'output', 'outputS3Path', ], 'members' => [ 'KMSArn' => [ 'shape' => 'KMSArn', ], 'applyNormalization' => [ 'shape' => 'Boolean', ], 'output' => [ 'shape' => 'OutputSourceOutputList', ], 'outputS3Path' => [ 'shape' => 'OutputSourceOutputS3PathString', ], ], ], 'OutputSourceConfig' => [ 'type' => 'list', 'member' => [ 'shape' => 'OutputSource', ], 'max' => 1, 'min' => 1, ], 'OutputSourceOutputList' => [ 'type' => 'list', 'member' => [ 'shape' => 'OutputAttribute', ], 'max' => 750, 'min' => 0, ], 'OutputSourceOutputS3PathString' => [ 'type' => 'string', 'pattern' => '^s3://([^/]+)/?(.*?([^/]+)/?)$', ], 'RecordAttributeMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'RecordAttributeMapKeyString', ], 'value' => [ 'shape' => 'RecordAttributeMapValueString', ], 'sensitive' => true, ], 'RecordAttributeMapKeyString' => [ 'type' => 'string', 'max' => 255, 'min' => 0, 'pattern' => '^[a-zA-Z_0-9- \\t]*$', ], 'RecordAttributeMapValueString' => [ 'type' => 'string', 'max' => 255, 'min' => 0, 'pattern' => '^[a-zA-Z_0-9-.@ ()+\\t]*$', ], 'ResolutionTechniques' => [ 'type' => 'structure', 'members' => [ 'resolutionType' => [ 'shape' => 'ResolutionType', ], 'ruleBasedProperties' => [ 'shape' => 'RuleBasedProperties', ], ], ], 'ResolutionType' => [ 'type' => 'string', 'enum' => [ 'RULE_MATCHING', 'ML_MATCHING', ], ], 'ResourceNotFoundException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], 'Rule' => [ 'type' => 'structure', 'required' => [ 'matchingKeys', 'ruleName', ], 'members' => [ 'matchingKeys' => [ 'shape' => 'RuleMatchingKeysList', ], 'ruleName' => [ 'shape' => 'RuleRuleNameString', ], ], ], 'RuleBasedProperties' => [ 'type' => 'structure', 'required' => [ 'attributeMatchingModel', 'rules', ], 'members' => [ 'attributeMatchingModel' => [ 'shape' => 'AttributeMatchingModel', ], 'rules' => [ 'shape' => 'RuleBasedPropertiesRulesList', ], ], ], 'RuleBasedPropertiesRulesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Rule', ], 'max' => 15, 'min' => 1, ], 'RuleMatchingKeysList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AttributeName', ], 'max' => 15, 'min' => 1, ], 'RuleRuleNameString' => [ 'type' => 'string', 'max' => 255, 'min' => 0, 'pattern' => '^[a-zA-Z_0-9- \\t]*$', ], 'SchemaAttributeType' => [ 'type' => 'string', 'enum' => [ 'NAME', 'NAME_FIRST', 'NAME_MIDDLE', 'NAME_LAST', 'ADDRESS', 'ADDRESS_STREET1', 'ADDRESS_STREET2', 'ADDRESS_STREET3', 'ADDRESS_CITY', 'ADDRESS_STATE', 'ADDRESS_COUNTRY', 'ADDRESS_POSTALCODE', 'PHONE', 'PHONE_NUMBER', 'PHONE_COUNTRYCODE', 'EMAIL_ADDRESS', 'UNIQUE_ID', 'DATE', 'STRING', ], ], 'SchemaInputAttribute' => [ 'type' => 'structure', 'required' => [ 'fieldName', 'type', ], 'members' => [ 'fieldName' => [ 'shape' => 'AttributeName', ], 'groupName' => [ 'shape' => 'AttributeName', ], 'matchKey' => [ 'shape' => 'AttributeName', ], 'type' => [ 'shape' => 'SchemaAttributeType', ], ], ], 'SchemaInputAttributes' => [ 'type' => 'list', 'member' => [ 'shape' => 'SchemaInputAttribute', ], 'max' => 25, 'min' => 2, ], 'SchemaMappingArn' => [ 'type' => 'string', 'pattern' => '^arn:(aws|aws-us-gov|aws-cn):entityresolution:.*:[0-9]+:(schemamapping/.*)$', ], 'SchemaMappingList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SchemaMappingSummary', ], ], 'SchemaMappingSummary' => [ 'type' => 'structure', 'required' => [ 'createdAt', 'schemaArn', 'schemaName', 'updatedAt', ], 'members' => [ 'createdAt' => [ 'shape' => 'Timestamp', ], 'schemaArn' => [ 'shape' => 'SchemaMappingArn', ], 'schemaName' => [ 'shape' => 'EntityName', ], 'updatedAt' => [ 'shape' => 'Timestamp', ], ], ], 'StartMatchingJobInput' => [ 'type' => 'structure', 'required' => [ 'workflowName', ], 'members' => [ 'workflowName' => [ 'shape' => 'EntityName', 'location' => 'uri', 'locationName' => 'workflowName', ], ], ], 'StartMatchingJobOutput' => [ 'type' => 'structure', 'required' => [ 'jobId', ], 'members' => [ 'jobId' => [ 'shape' => 'JobId', ], ], ], 'String' => [ 'type' => 'string', ], 'TagKey' => [ 'type' => 'string', 'max' => 128, 'min' => 1, ], 'TagKeyList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TagKey', ], 'max' => 200, 'min' => 0, ], 'TagMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'TagKey', ], 'value' => [ 'shape' => 'TagValue', ], 'max' => 200, 'min' => 0, ], 'TagResourceInput' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tags', ], 'members' => [ 'resourceArn' => [ 'shape' => 'VeniceGlobalArn', 'location' => 'uri', 'locationName' => 'resourceArn', ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'TagResourceOutput' => [ 'type' => 'structure', 'members' => [], ], 'TagValue' => [ 'type' => 'string', 'max' => 256, 'min' => 0, ], 'ThrottlingException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 429, 'senderFault' => true, ], 'exception' => true, 'retryable' => [ 'throttling' => true, ], ], 'Timestamp' => [ 'type' => 'timestamp', ], 'UntagResourceInput' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tagKeys', ], 'members' => [ 'resourceArn' => [ 'shape' => 'VeniceGlobalArn', 'location' => 'uri', 'locationName' => 'resourceArn', ], 'tagKeys' => [ 'shape' => 'TagKeyList', 'location' => 'querystring', 'locationName' => 'tagKeys', ], ], ], 'UntagResourceOutput' => [ 'type' => 'structure', 'members' => [], ], 'UpdateMatchingWorkflowInput' => [ 'type' => 'structure', 'required' => [ 'inputSourceConfig', 'outputSourceConfig', 'resolutionTechniques', 'roleArn', 'workflowName', ], 'members' => [ 'description' => [ 'shape' => 'Description', ], 'incrementalRunConfig' => [ 'shape' => 'IncrementalRunConfig', ], 'inputSourceConfig' => [ 'shape' => 'InputSourceConfig', ], 'outputSourceConfig' => [ 'shape' => 'OutputSourceConfig', ], 'resolutionTechniques' => [ 'shape' => 'ResolutionTechniques', ], 'roleArn' => [ 'shape' => 'String', ], 'workflowName' => [ 'shape' => 'EntityName', 'location' => 'uri', 'locationName' => 'workflowName', ], ], ], 'UpdateMatchingWorkflowOutput' => [ 'type' => 'structure', 'required' => [ 'inputSourceConfig', 'outputSourceConfig', 'resolutionTechniques', 'roleArn', 'workflowName', ], 'members' => [ 'description' => [ 'shape' => 'Description', ], 'incrementalRunConfig' => [ 'shape' => 'IncrementalRunConfig', ], 'inputSourceConfig' => [ 'shape' => 'InputSourceConfig', ], 'outputSourceConfig' => [ 'shape' => 'OutputSourceConfig', ], 'resolutionTechniques' => [ 'shape' => 'ResolutionTechniques', ], 'roleArn' => [ 'shape' => 'String', ], 'workflowName' => [ 'shape' => 'EntityName', ], ], ], 'ValidationException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'VeniceGlobalArn' => [ 'type' => 'string', 'pattern' => '^arn:(aws|aws-us-gov|aws-cn):(entityresolution):.*:[0-9]+:((schemamapping|matchingworkflow)/[a-zA-Z0-9_-]+)$', ], ],];
