<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'facetoface', language 'es_mx', version '4.3'.
 *
 * @package     facetoface
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addingsession'] = 'Añadiendo una nueva sesión en {$a}';
$string['addmanageremailaddress'] = 'Añadir dirección Email del mánager';
$string['addmanageremailinstruction'] = 'Usted no había escrito previamente la dirección Email de su mánager. Por favor escríbala debajo para apuntarlo para esta sesión';
$string['addnewfield'] = 'Añadir un nuevo campo personalizado';
$string['addnewfieldlink'] = 'Crear un nuevo campo personalizado';
$string['addnewnotice'] = 'Añadir un nuevo aviso personalizado';
$string['addnewnoticelink'] = 'Crear un nuevo aviso del sitio';
$string['addremoveattendees'] = 'Añadir/remover asistentes';
$string['addsession'] = 'Añadir una nueva sesión';
$string['addstudent'] = 'Añadir estudiante';
$string['addtoallsessions'] = 'Añadir usuarios a todas las sesiones (próximas)';
$string['addtoallsessions_help'] = 'Use esta opción si desea añadir usuarios a todas las sesiones próximas de Face-to-Face';
$string['alllocations'] = 'Todos los lugares';
$string['allowcancellations'] = 'Permitir cancelaciones apuntados';
$string['allowcancellations_help'] = 'Si se activa, los asistentes a la sesión podrán cancelar sus pre-inscripciones';
$string['allowcancellationsdefault'] = 'Por defecto permitir cancelaciones apuntados';
$string['allowcancellationsdefault_help'] = 'Si se activa, la configuración por defecto al crear sesiones nuevas para esta actividad será permitir cancelaciones de apuntados';
$string['allowoverbook'] = 'Permitir reservaciones excesivas';
$string['allowoverbook_help'] = 'Cuando se activa "Permitir reservaciones excesivas" los estudiantes podrán apuntarse a una sesión Cara-a-Cara aunque ya esté llena.</p>

<p>Cuando un estudiante se apunta a una sesión que ya está llena, recibirá un correo electrónico que le avisa que está en lista de espera para la sesión y será notificados en cuanto haya una reservación disponible.';
$string['allsessionsin'] = 'Todas las sesiones en {$a}';
$string['alreadysignedup'] = 'Usted ya se había apuntado para esta actividad Cara-a-Cara.';
$string['answer'] = 'Apuntarse';
$string['answercancel'] = 'Des-apuntarse';
$string['approvalreqd'] = 'Requiere aprobación';
$string['approvalreqd_help'] = 'Cuando se activa "Aprobaciónnecesaria", un estudiante necesitará aprobación de su mánager para que se le permita asistir a una sesión Cara-a-Cara.';
$string['approve'] = 'Aprobar';
$string['assessmentyour'] = 'Su valoración';
$string['attendance'] = 'Asistencia';
$string['attendanceinstructions'] = 'Seleccionar usuarios que asistieron a la sesión';
$string['attendedsession'] = 'Sesión asistida';
$string['attendees'] = 'Asistentes';
$string['attendeesexporttofileheading'] = 'Asistentes exportados a archivo';
$string['booked'] = 'Reservada';
$string['bookingcancelled'] = 'Su reservación ha sido cancelada.';
$string['bookingcompleted'] = 'Su reservación ha sido completada.';
$string['bookingfull'] = 'Reservaciones llenas';
$string['bookingopen'] = 'Reservaciones abiertas';
$string['bookingstatus'] = 'Usted está reservado para la siguiente sesión';
$string['calendareventdescriptionbooking'] = 'Usted está agendado para esta <a href="{$a}">sesión Cara-a-Cara</a>.';
$string['calendareventdescriptionsession'] = 'Usted ha creado esta <a href="{$a}">sesión Cara-a-Cara</a>.';
$string['calendaroptions'] = 'Opciones de calendario';
$string['cancelbooking'] = 'Cancelar reservación';
$string['cancelbookingfor'] = 'Cancelar reservación para {$a}';
$string['cancellation'] = 'Cancelación';
$string['cancellationconfirm'] = '¿Está Usted seguro de querer cancelar su reservación para esta sesión ?';
$string['cancellationinstrmngr'] = '# Aviso para el mánager';
$string['cancellationinstrmngr_help'] = 'Cuando está activado **Mandar aviso al mánager**, el texto en el campo de **Aviso para el mánager** es enviado a un mánager de aprendizaje, avisándole que han cancelado una reservación Cara-a-Cara.';
$string['cancellationmessage'] = 'Mensaje de cancelación';
$string['cancellationmessage_help'] = 'Este mensaje se manda cuando los usuarios cancelan su reservación para una sesión.';
$string['cancellations'] = 'Cancelaciones';
$string['cancellationsent'] = 'Usted debería de recibir inmediatamente un Email de cancelación.';
$string['cancellationsentmgr'] = 'Usted y su mánager deberían de recibir inmediatamente un Email de cancelación.';
$string['cancellationstablesummary'] = 'Lista de personas que han cancelado sus pre-inscripciones a la sesión';
$string['cancelreason'] = 'Razón';
$string['cannotapproveatcapacity'] = 'Usted ya no puede aprobar más asistentes, porque esta sesión está llena.';
$string['cannotsignupsessioninprogress'] = 'Usted no puede apuntarse, esta sesión está en progreso';
$string['cannotsignupsessionover'] = 'Usted no puede apuntarse, esta sesión ya terminó';
$string['capacity'] = 'Capacidad';
$string['capacity_help'] = '**Capacidad** es el número de asientos disponibles en una sesión.

Cuando una sesión Cara-a-Cara alcanza su capacidad, los detalles de la sesión no aparecen en la página del curso. Los detalles aparecerán sombreados en gris en la página de \'Ver todas las sesiones\' y el estudiante no podrá inscribirse a la sesión.  ';
$string['caseinsensitive'] = 'NO importan minúsculas/MAYÚSCULAS';
$string['changemanageremailaddress'] = 'Cambiar dirección Email del mánager';
$string['changemanageremailinstruction'] = 'Por favor escriba debajo la dirección Email para su mánager actual.';
$string['clearall'] = 'Borrar todo';
$string['closed'] = 'Cerrada';
$string['completiondetail:attendance'] = 'Requerir asistencia';
$string['completiondetail:attendance_disabled'] = 'Asistencia no es requerida';
$string['completiondetail:attendance_full'] = 'Se requiere asistencia completa';
$string['completiondetail:attendance_partial'] = 'Se requiere al menos asistencia parcial';
$string['conditions'] = 'Condiciones';
$string['conditionsexplanation'] = 'Todos estos criterios deben de cumplirse para que el aviso se muestre en el calendario de entrenamiento:';
$string['confirm'] = 'Confirmar';
$string['confirmanager'] = 'Confirmar dirección Email del mánager';
$string['confirmation'] = 'Confirmación';
$string['confirmationinstrmngr'] = '# Aviso al mánager';
$string['confirmationinstrmngr_help'] = 'Cuando se activa "Mandar aviso al mánager", el texto en el campo de "Aviso para el mánager" se envía, notificándole que un miembro del staff se ha apuntado para una sesión Cara-a-Cara.';
$string['confirmationmessage'] = 'Mensaje de confirmación';
$string['confirmationmessage_help'] = 'Este mensaje se manda cuando los usuarios se apuntan para una sesión.';
$string['confirmationsent'] = 'Usted debería recibir inmediatamente un Email de confirmación.';
$string['confirmationsentmgr'] = 'Usted y su mánager deberían recibir inmediatamente un Email de confirmación.';
$string['confirmmanageremailaddress'] = 'Confirmar dirección Email del mánager';
$string['confirmmanageremailaddressquestion'] = '¿Todavía sigue siendo <b>{$a}</b> la dirección de Email de su mánager?';
$string['confirmmanageremailinstruction1'] = 'Usted previamente escribió la siguiente dirección de Email de su mánager:';
$string['confirmmanageremailinstruction2'] = '¿Todavía es esta la dirección de Email de su mánager?';
$string['continuetologin'] = 'Elija continuar para entrar';
$string['copy'] = 'Copiar';
$string['copyingsession'] = 'Copiando como una nueva sesión en {$a}';
$string['copysession'] = 'Copiar sesión';
$string['cost'] = 'Costo';
$string['costheading'] = 'Costo de sesión';
$string['crontask'] = 'Trabajos de mantenimiento en Cara-a-Cara';
$string['currentstatus'] = 'Estatus actual';
$string['customfield_notvisible'] = 'Nadie';
$string['customfield_visibility'] = 'Visible para';
$string['customfield_visibility_help'] = 'Esta configuración determina quén puede ver el campo personalizado y el valor al enlistar sesiones en la página del módulo o cuando se registra  para una sesión.';
$string['customfield_visibletoall'] = 'Todos';
$string['customfield_visibletoteachers'] = 'Profesores';
$string['customfieldid'] = 'ID campo personalizado';
$string['customfieldnewshortname'] = 'Nombre corto nuevo de campo personalizado';
$string['customfieldoriginalshortname'] = 'Nombre corto original de campo personalizado';
$string['customfieldsheading'] = 'Campos personalizados de sesión';
$string['date'] = 'Fecha';
$string['dateadd'] = 'Añadir una nueva fecha';
$string['dateremove'] = 'Quitar esta fecha';
$string['datesignedup'] = 'Fecha inscrita';
$string['datetext'] = 'Usted está inscrito para la fecha';
$string['datetimeknownhinttext'] = '';
$string['decidelater'] = 'Decidir más tarde';
$string['decline'] = 'Declinar';
$string['delete'] = 'Eliminar';
$string['deleteall'] = 'Eliminar todo';
$string['deletesession'] = 'Eliminar sesión';
$string['deletesessionconfirm'] = '¿Está Usted completamente seguro de querer eliminar esta sesión y a todos los que se apuntaron a esta sesión?';
$string['deletingsession'] = 'Eliminando sesión en {$a}';
$string['description'] = 'Texto de introducción';
$string['description_help'] = '**Descripción** es la descripción del curso que se muestra cuando un estudiante se inscribe en una sesión Cara-a-Cara.

La **Descripción** también se muestra en el calendario de entrenamiento.';
$string['details'] = 'Detalles';
$string['details_help'] = 'Los detalles se toman con base en cada sesión.
Si hay texto en el campo de detalles, el texto de detalles se mostrará en la página de pre-inscripción del usuario.
Por defecto, el texto de detalles también aparece en los Emails de la confirmación, el recordatorio, la lista de espera y la cancelación.';
$string['discountcode'] = 'Código para descuento';
$string['discountcode_help'] = 'El código para descuento es el código requerido para que se registre el costo con descuento para un miembro del staff o un profesor.
Si el miembro del staff no escribe el código de descuento, aparecerá el costo normal en el registro del entrenamiento.';
$string['discountcodelearner'] = 'Código de Descuento';
$string['discountcodelearner_help'] = 'Si conoce el código de descuento, ingréselo aquí. Si deja este campo vacío se lecobrará el costo normal para este evento.';
$string['discountcost'] = 'Costo con descuento';
$string['discountcost_help'] = 'El costo con descuento es la cantidad que se cobra a los miembros del staff que tienen una identificación (con número) de empleado.
Si un miembro del staff escribe un número de identificación de empleado al inscribirse a una sesión, el costo con descuento aparecerá en la columna de costos en el libro de calificaciones del curso.';
$string['discountcosthinttext'] = '';
$string['due'] = 'pagadero';
$string['duration'] = 'Duración';
$string['duration_help'] = 'La **Duración** es la extensión total del entrenamiento en horas.
Por ejemplo:
* "2 horas" se escribe como **2** o **2:00**
* "1 hora con 30 minutos" se escribe como **1:30**
* "45 minutos" se escribe como **0:45**
* "20 minutos" se escribe como **0:20**.

Si el entrenamiento ocurre en dos o más períodos de tiempo, la duración es el total combinado.';
$string['early'] = '{$a} anticipado';
$string['edit'] = 'Editar';
$string['editingsession'] = 'Editando sesión en {$a}';
$string['editsession'] = 'Editar sesión';
$string['email:instrmngr'] = 'Aviso para el mánager';
$string['email:message'] = 'Mensaje';
$string['email:subject'] = 'Asunto';
$string['emailmanager'] = 'Mandar aviso al mánager';
$string['emailmanagercancellation'] = '# Mandar aviso al mánager';
$string['emailmanagercancellation_help'] = 'Cuando esté activado "Mandar aviso a mánager", se enviará un Email al mánager del alumno para avisarle de que se ha cancelado la reservación Cara-a-Cara.';
$string['emailmanagerconfirmation'] = '# Mandar aviso al mánager';
$string['emailmanagerconfirmation_help'] = 'Cuando esté activado "Mandar aviso a mánager", se enviará un Email de confirmación al mánager del alumno en cuanto el alumno se apunte para una sesión Cara-a-Cara.';
$string['emailmanagerreminder'] = '# Mandar aviso al mánager';
$string['emailmanagerreminder_help'] = 'Cuando esté activado "Mandar aviso a mánager", se enviará un recordatorio en Email  al mánager del alumno unos cuantos días antes de la fecha de inicio de la sesión Cara-a-Cara.';
$string['emptylocation'] = 'El lugar estaba vacío';
$string['enrolled'] = 'inscrito';
$string['error:addalreadysignedupattendee'] = '{$a} ya está apuntado para esta actividad Cara-a-Cara..';
$string['error:addattendee'] = 'No se pudo añadir {$a} a la sesión.';
$string['error:bookingsuploadfileerrorsfound'] = '{$a} errores fueron encontrados en el archivo subido. Las reservaciones no pueden ser procesadas hasta que se hayan resuelto.';
$string['error:bookingsuploadfileheaderfieldmismatch'] = 'Número discordante de campos en el archivo subido en fila {$a}.';
$string['error:cancelbooking'] = 'Hubo un problema al cancelar su reservación';
$string['error:cancellationsnotallowed'] = 'Usted no tiene permitido cancelar este registro.';
$string['error:cancellationtooclose'] = 'Usted no tiene permitido cancelar esta reservación. Las reservaciones solo pueden ser canceladas {$a} antes de la sesión.';
$string['error:cannotemailmanager'] = 'Se envió Email recordatorio para ID de envío  {$a->submissionid} al usuario {$a->userid}, pero no pudo enviarse el mensaje a la dirección Email del mánager del usuario ({$a->manageremail}).';
$string['error:cannotemailuser'] = 'No pudo enviarse Email para ID de envío {$a->submissionid} al usuario {$a->userid} ({$a->useremail}).';
$string['error:cannotloadfile'] = 'No se puede subir el archivo; por favor revise el archivo e inténtelo nuevamente.';
$string['error:cannotprocessbookingsvalidationerrorsexist'] = 'Hay errores de validación que necesitan ser atendidos antes de que el archivo pueda ser procesado completamente. Por favor corríjalos e intente de nuevo.';
$string['error:cannotsendconfirmationmanager'] = 'Se envió un mensaje de confirmación a su cuenta de Email, pero hubo un problema al enviar el mensaje de confirmación a la dirección Email de su mánager.';
$string['error:cannotsendconfirmationthirdparty'] = 'Se envió un mensaje de confirmación a su cuenta de Email y a la de su mánager, pero hubo un problema al enviar el mensaje de confirmación a la dirección Email de una tercera persona.';
$string['error:cannotsendconfirmationuser'] = 'Hubo un problema al enviar el mensaje de confirmación a su cuenta de Email.';
$string['error:cannotsendconfirmationusermanager'] = 'No se pudo enviar un mensaje de confirmación a su dirección de Email y a la dirección de Email de su mánager.';
$string['error:cannotsendrequestmanager'] = 'Hubo un problema al enviar el mensaje de solicitud de pre-inscripción a la cuenta de Email de su mánager.';
$string['error:cannotsendrequestuser'] = 'Hubo un problema al enviar el mensaje de solicitud de pre-inscripción a su cuenta de Email.';
$string['error:canttakeattendanceforunstartedsession'] = 'No se puede tomar asistencia para una sesión que todavía no empieza.';
$string['error:couldnotaddfield'] = 'No se pudo añadir campo de sesión personalizado.';
$string['error:couldnotaddnotice'] = 'No se pudo añadir aviso del sitio.';
$string['error:couldnotaddsession'] = 'No se pudo añadir sesión';
$string['error:couldnotaddtrainer'] = 'No se pudo guardar al entrenador de sesión Cara-a-Cara';
$string['error:couldnotcopysession'] = 'No se pudo copiar sesión';
$string['error:couldnotdeletefield'] = 'No se pudo eliminar campo de sesión personalizado';
$string['error:couldnotdeletenotice'] = 'No se pudo eliminar aviso del sitio';
$string['error:couldnotdeletesession'] = 'No se pudo eliminar sesión';
$string['error:couldnotdeletetrainer'] = 'No se pudo eliminar al entrenador de la sesión Cara-a-Cara';
$string['error:couldnotfindsession'] = 'No se pudo encontrar la nueva sesión insertada';
$string['error:couldnotsavecustomfield'] = 'No se pudo guardar el campo personalizado';
$string['error:couldnotupdatecalendar'] = 'No se pudo actualizar el evento de sesión en el calendario.';
$string['error:couldnotupdatef2frecord'] = 'No se pudo actualizar el registro de pre-inscripción a Cara-a-Cara en la base de datos';
$string['error:couldnotupdatefield'] = 'No se pudo actualizar el campo de sesión personalizada.';
$string['error:couldnotupdatemanageremail'] = 'No se pudo actualizar la dirección Email del mánager.';
$string['error:couldnotupdatenotice'] = 'No se pudo actualizar el aviso del sitio.';
$string['error:couldnotupdatesession'] = 'No se pudo actualizar la sesión';
$string['error:coursemisconfigured'] = 'El curso está mal configurado';
$string['error:cronprefix'] = 'Error: cron de Cara-a-Cara:';
$string['error:emptylocation'] = 'El lugar estaba vacío.';
$string['error:emptymanageremail'] = 'La dirección Email del mánager estaba vacía.';
$string['error:emptyvenue'] = 'El sitio estaba vacío.';
$string['error:enrolmentfailed'] = 'No se pudo inscribir a {$a} al curso.';
$string['error:eventoccurred'] = 'Usted no puede cancelar un evento que ya ocurrió.';
$string['error:f2ffailedupdatestatus'] = 'Cara-a-Cara no pudo actualizar el estatus del usuario';
$string['error:fieldidincorrect'] = 'La ID del campo es incorrecta: {$a}';
$string['error:incorrectcoursemodule'] = 'El módulo del curso es incorrecto';
$string['error:incorrectcoursemoduleid'] = 'La ID del módulo del curso es incorrecta';
$string['error:incorrectcoursemodulesession'] = 'La sesión Cara-a-Cara del módulo del curso era incorrecta';
$string['error:incorrectfacetofaceid'] = 'La ID de Cara-a-Cara era incorrecta';
$string['error:incorrectnotificationtype'] = 'El tipo de notificación suministrado era incorrecto';
$string['error:invalidnotificationtypespecified'] = 'Tipo de notificación especificado inválido. Se esperaba \'ical\', \'email\', \'both\', o \'\', pero resultó ser \'{\\$a}\'';
$string['error:invalidstatusspecified'] = 'Estatus especificado inválido. Se esperaba \'reservado\', \'cancelado\', \'no_show\', \'parcialmente_asistido\', o \'completamente_asistido\'. Se cambia a \'reservado\' si estaba vacío. El valor proporcionado era \'{\\$a}\'';
$string['error:invaliduserid'] = 'ID de usuario inválida';
$string['error:manageremailaddressmissing'] = 'Usted actualmente no está asignado a un mánager en el sistema. Por favor póngase en contacto con el administrador del sitio.';
$string['error:multipleusersessions'] = 'Ususario {$a} tiene más de una sesión';
$string['error:multipleusersmatched'] = 'Múltiples usuarios coincidieron con identificador {$a}';
$string['error:mustspecifycoursemodulefacetoface'] = 'Usted debe especificar un módulo de curso o una ID de Cara-a-Cara';
$string['error:nomanageremail'] = 'Usted no proporcionó una dirección Email para su mánager';
$string['error:nomanagersemailset'] = 'No está configurada Email de mánager';
$string['error:nopermissiontosignup'] = 'Usted no tiene permiso para pre-inscribirse en esta sesión Cara-a-Cara.';
$string['error:noticeidincorrect'] = 'ID del aviso es incorrecto: {$a}';
$string['error:problemsigningup'] = 'Hubo un problema al apuntarlo.';
$string['error:removeattendee'] = 'No se pudo remover a {$a} de la sesión.';
$string['error:sessionalreadystarted'] = 'No se puede usar sesión {$a}, porque ya ha iniciado.';
$string['error:sessiondoesnotexist'] = 'Sesión ID {$a} no existe.';
$string['error:sessionoverbooked'] = 'Sesión ID {$a->session} sobre-reservada por {$a->amount} persona(s).';
$string['error:sessionstartafterend'] = 'La hora/fecha de inicio es posterior a la fecha de término.';
$string['error:shortnametaken'] = 'Ya existe un campo personalizado con este nombre corto.';
$string['error:signedupinothersession'] = 'Usted ya está apuntado en otra sesión para esta actividad. Usted solamente puede apuntarse a una sesión por cada actividad Cara-a-Cara.';
$string['error:tryingtoupdatesessionfromanothermodule'] = 'No se puede actualizar sesión id {$a->session} la cual pertenece a otra actividad Cara-a-Cara con id {$a->f}.';
$string['error:unknownbuttonclicked'] = 'No hay acción asociada al botón que se oprimió';
$string['error:userdoesnotexist'] = 'Usuario {$a} no existe.';
$string['error:userisnotenrolledintocourse'] = 'Usuario {$a} no está inscrito en este curso.';
$string['eventaddsession'] = 'Sesión añadida';
$string['eventaddsessionfailed'] = 'Sesión añadida (FALLÓ)';
$string['eventapproverequests'] = 'Aprobar solicitudes de sesión';
$string['eventattendancetaken'] = 'Asistencia de sesión tomada';
$string['eventattendeesviewed'] = 'Asistencia de sesión vista';
$string['eventcancelbooking'] = 'Cancelar reservación de sesión';
$string['eventcancelbookingfailed'] = 'Cancelar reservación de sesión (FALLÓ)';
$string['eventcoursef2fviewed'] = 'Instancias de Cara-a-Cara de Curso vistas';
$string['eventcoursemoduleviewed'] = 'Instancias de módulo Cara-a-Cara de Curso vistas';
$string['eventcsvprocessed'] = 'CSV procesado';
$string['eventdeletesession'] = 'Sesión eliminada';
$string['eventdeletesessionfailed'] = 'Sesión eliminada (FALLÓ)';
$string['eventsignup'] = 'Pre-inscripción a sesión';
$string['eventsignupfailed'] = 'Pre-inscripción a sesión (FALLÓ)';
$string['eventtakeattendancefailed'] = 'Tomar asistencia de sesión (FALLÓ)';
$string['eventupdatemanageremailfailed'] = 'Actualizar Email mánager (FALLÓ)';
$string['eventupdatesession'] = 'Sesión actualizada';
$string['eventupdatesessionfailed'] = 'Sesión actualizada (FALLÓ)';
$string['excelformat'] = 'Excel';
$string['export'] = 'Exportar';
$string['exportattendance'] = 'Exportar asistencia';
$string['exporttofile'] = 'Exportar a archivo';
$string['facetoface'] = 'Cara-a-Cara';
$string['facetoface:addattendees'] = 'Añadir asistentes a una sesión Cara-a-Cara';
$string['facetoface:addinstance'] = 'Añadir instancia';
$string['facetoface:configurecancellation'] = 'Permitir la configuración de cancelaciones de registro, al a{adir/editar una actividad Cara-a-Cara.';
$string['facetoface:confirmandprocess'] = 'Confirmar y procesar';
$string['facetoface:createsitewideevent'] = 'Permitir creación de eventos de calendario para todo el sitio';
$string['facetoface:csvprocessed'] = 'Registros procesados exitosamente';
$string['facetoface:editsessions'] = 'Añadir,editar, copiar y eliminar sesiones Cara-a-Cara';
$string['facetoface:examplecsv'] = 'Archivo de texto de ejemplo';
$string['facetoface:overbook'] = 'Apuntarse a sesiones llenas.';
$string['facetoface:removeattendees'] = 'Remover asistentes de sesión Cara-a-Cara';
$string['facetoface:signup'] = 'Apuntarse para una sesión';
$string['facetoface:takeattendance'] = 'Tomar asistencia';
$string['facetoface:uploadandpreview'] = 'Subir y validar reservaciones';
$string['facetoface:uploadbookings'] = 'Subir reservaciones';
$string['facetoface:uploadbookingsfile'] = 'Archivo de reservaciones';
$string['facetoface:uploadbookingsfiledesc'] = 'Campos esperados:
- Dirección Email (requerido)
- Número de sesión (requerido)
- Código de descuento (opcional)
- Tipo de notificación (opcional - las opciones válidas son \'email\', \'ical\', o \'ambas\')';
$string['facetoface:uploadreadytoprocess'] = 'El archivo subido ha sido validado y está listo para ser procesado.';
$string['facetoface:validatebookings'] = 'Validar reservaciones';
$string['facetoface:view'] = 'Ver actividades y sesiones Cara-a-Cara';
$string['facetoface:viewattendees'] = 'Ver lista de asistencia y asistentes';
$string['facetoface:viewcancellations'] = 'Ver cancelaciones';
$string['facetoface:viewemptyactivities'] = 'Ver actividades vacías Cara-a-Cara';
$string['facetofacebooking'] = 'Reservación Cara-a-Cara';
$string['facetofacename'] = 'Nombre Cara-a-Cara';
$string['facetofacesession'] = 'Sesión Cara-a-Cara';
$string['feedback'] = 'Retroalimentación';
$string['feedbackupdated'] = 'Se actualizó la retroalimentación para \\{$a} personas';
$string['field:multiselect'] = 'Selección múltiple';
$string['field:select'] = 'Menú de elecciones';
$string['field:text'] = 'Texto';
$string['fielddeleteconfirm'] = '¿Borrar el campo \'{$a}\' y todos los datos de sesión asociados al mismo ?';
$string['floor'] = 'Piso';
$string['format'] = 'Formato';
$string['full'] = 'La fecha está completamente ocupada';
$string['goback'] = 'Regresar';
$string['guestsno'] = 'Lo siento, los invitados no pueden inscribirse a sesiones.';
$string['icalendarheading'] = 'Anexos de iCalendar';
$string['import'] = 'Importar';
$string['info'] = 'Información';
$string['late'] = '{$a} tarde';
$string['location'] = 'Lugar';
$string['location_help'] = '**Lugar** describe los alrededores de la sesión (ciudad, municipio, región, barrio, colonia, etc).

**Lugar** se muestra en la página del curso, la página patra inscribirse, la página para \'Ver todas las sesiones\' y en todas las notificaciones por Email.

En la página de \'Ver todas las sesiones\', las sesiones enlistadas se pueden filtrar por lugar.';
$string['lookfor'] = 'Buscar';
$string['manageradded'] = 'La dirección Email de su mánager ha sido aceptada.';
$string['managerchanged'] = 'La dirección Email de su mánager ha sido cambiada.';
$string['manageremail'] = 'Email del mánager';
$string['manageremailaddress'] = 'Diirección Email del mánager';
$string['manageremaildisabled'] = 'Las configuraciones del Email del mánager no están disponibles si las aprobaciones del mánager no están habilitadas.';
$string['manageremailformat'] = 'La dirección Email debe estar en el formato \'{$a}\' para ser aceptada.';
$string['manageremailheading'] = 'Emails de mánager';
$string['manageremailinstruction'] = 'Para apuntarse a una sesión de entrenamiento, se debe enviar un Email de confirmación a su dirección de Email y copiarse a la dirección de Email de su mánager.';
$string['manageremailinstructionconfirm'] = 'Por favor confirme que esta es la dirección Email de su mánager:';
$string['managername'] = 'Nombre de mánager';
$string['managerupdated'] = 'La dirección Email de su mánager ha sido actualizada.';
$string['maximumpoints'] = 'Número máximo de puntos';
$string['maximumsize'] = 'Número máximo de asistentes';
$string['message'] = '¡Cambio en reservación en el curso {$a->coursename}!

Se ha desocupado un lugar en la sesión de {$a->duedate} ({$a->name}) en el curso {$a->coursename}.

Usted ha sido registrado. Si esta fecha no le acomoda, por favor haga su des-registro en  <a href=\'{$a->url}\'>{$a->url}</a>.';
$string['mods_help'] = 'Las actividades Cara-a-Cara se usan para monitorear los entrenamientos presenciales personalizados que requieren reservación por anticipado.

Cada actividad se ofrece en una o más sesiones idénticas. Estas sesiones pueden durar varios días.

Se envían mensajes recordatorios a los usuarios y a sus mánagers unos cuantos días antes de la fecha cuando  la sesión está agendada para iniciar. Se envían mensajes de confirmación cuando los usuarios se apuntan para una sesión o la cancelan.';
$string['modulename'] = 'Cara-a-Cara';
$string['modulename_help'] = 'El módulo de la actividad Cara-a-Cara le permite al profesor configurar un sistema voluntario de reservaciones  para una o varias sesiones basadas en salón de clase o con-personas.

Cada sesión dentro de una actividad Cara-a-Cara puede tener configuraciones personalizadas sobre lugar, sitio, hora de inicio, hora de término, costo, capacidad, etc. Estas pueden configurarse para comprender varios días  o para permitir sesiones no-agendadas o en lista de espera.

Una actividad puede configurarse para que requiera aprobación del mánager y los profesores pueden configurar notificaciones automáticas y recordatorios de sesiones para los asistentes.

Los estudiantes pueden ver e inscribirse a sesiones con su asistencia supervisada y grabada en el área de Calificaciones.';
$string['modulenameplural'] = 'Cara-a-Cara';
$string['moreinfo'] = 'Más información';
$string['multidate'] = '(multi-fecha)';
$string['multiple'] = 'Múltiple';
$string['multiplesignupmethod'] = 'Método de apuntarse múltiple';
$string['multiplesignupmethod_help'] = 'Cuando se configura a "Por sesión" los estudiantes se apuntan para cada sesión dentro de la actividad Cara-aCara  individualmente. cuando se configura a "Por actividad" los estudiantes solamente tiene la opción de apuntarse a cada una de todas las sesiones dentro de la actividad Cara-aCara.';
$string['multiplesignupperactivity'] = 'Por actividad';
$string['multiplesignuppersession'] = 'Por sesión';
$string['newmanageremailaddress'] = 'Dirección Email de mánager';
$string['noactionableunapprovedrequests'] = 'No hay solicitudes no-aprobadas sobre las que pueda actuarse';
$string['nocustomfields'] = '<p>No hay campos personalizados definidos.</p>';
$string['nofacetofaces'] = 'No hay actividades Cara-a-Cara';
$string['none'] = 'ninguno';
$string['noremindersneedtobesent'] = 'No se necesitan enviar recordatorios';
$string['normalcost'] = 'Costo normal';
$string['normalcost_help'] = 'El costo normal es la cantidad en la moneda local que se les cobra a los miembros del staff que no tienen una ID con número de empleado.

El costo normal aparecerá en la columna de costo en el libro de calificaciones del curso para cada miembro del staff que asista a la sesión (a menos que se introduzca un costo con descuento y el miembro del staff escriba su número de empleado al apuntarse a la sesión).';
$string['normalcosthinttext'] = '';
$string['nosignedupusers'] = 'No se apuntaron usuarios a esta sesión.';
$string['nositenotices'] = '<p>No están definidos avisos del sitio.</p>';
$string['note'] = 'Aviso';
$string['notefull'] = 'Aún si la sesión estuviera completemente reservada, Usted puede registrarse. Usted será anotado en lista de espera (marcada en rojo). Si alguien se diera de baja, el primer estudiante en la lista de espera se moverá a estudiante registrado y se le enviará un Email de notificación.';
$string['noteinfo'] = 'Durante la última actualización del sitio el módulo Cara-a-Cara ha sido modificado. Ahora requiere que los campos personalizados de sesión tengan nombres cortos únicos. Debido a que algunos de sus campos personalizados tenían nombres cortos duplicados, ellos han sido renombrados para quitar los duplicados (vea la tabla debajo). esto podría impactar en sus mensajes de Email si usted referencía esos campos personalizados en las plantillas del mensaje.';
$string['noticedeleteconfirm'] = 'Eliminar aviso del sitio \'{$a->name}\'?<br/><blockquote>{$a->text}</blockquote>';
$string['noticetext'] = 'Texto del aviso';
$string['notificationboth'] = 'Notificación por Email y Agendado iCalendar';
$string['notificationemail'] = 'Solamente Notificación por Email';
$string['notificationical'] = 'Solamente agendado en iCalendar';
$string['notificationtype'] = 'Tipo de Notificación';
$string['notificationtype_help'] = 'El Tipo de Notificación le permite al estudiante seleccionar como le gustaría que le notifiquen sobre su reservación:

* Solamente agendado iCalendar
* Solamente notificación por Email
* Ambos iCalendario y Email';
$string['notsignedup'] = 'Usted no está apuntado para esta sesión';
$string['notsubmittedyet'] = 'Todavía no evaluado';
$string['noupcoming'] = '<p><i>No hay sesiones pendientes</i></p>';
$string['odsformat'] = 'OpenDocument (LibreOffice)';
$string['onehour'] = '1 hora';
$string['oneminute'] = '1 minuto';
$string['options'] = 'Opciones';
$string['or'] = 'o';
$string['order'] = 'Orden';
$string['place'] = 'Sala';
$string['placeholder:alldates'] = '[todaslasfechas]';
$string['placeholder:attendeeslink'] = '[enlaceasistentes]';
$string['placeholder:cost'] = '[costo]';
$string['placeholder:details'] = '[detalles]';
$string['placeholder:duration'] = '[duracion]';
$string['placeholder:facetofacename'] = '[nombrecaraacara]';
$string['placeholder:finishtime'] = '[horafin]';
$string['placeholder:firstname'] = '[nombre]';
$string['placeholder:lastname'] = '[apellidos]';
$string['placeholder:reminderperiod'] = '[periodorecordatorio]';
$string['placeholder:sessiondate'] = '[fechasesion]';
$string['placeholder:starttime'] = '[horainicio]';
$string['pluginadministration'] = 'Administración Cara-a-Cara';
$string['pluginname'] = 'Cara-a-Cara';
$string['points'] = 'Puntos';
$string['pointsplural'] = 'Puntos';
$string['potentialattendees'] = 'Asistentes Potenciales';
$string['previoussessions'] = 'Sesiones Previas';
$string['printversionid'] = 'Versión imprimible: sin nombre';
$string['printversionname'] = 'Versión imprimible: con nombre';
$string['privacy:metadata:facetoface_session_roles'] = 'Enlista usuarios con un rol de entrenador en una sesión cara-a-cara';
$string['privacy:metadata:facetoface_signups'] = 'Pre-inscripciones de usuario a sesiones Cara-a-Cara';
$string['privacy:metadata:facetoface_signups:discountcode'] = 'El código de descuento ingresado por el usuario';
$string['privacy:metadata:facetoface_signups:id'] = 'La ID de la pre-inscripción';
$string['privacy:metadata:facetoface_signups:mailedreminder'] = 'La última hora en que se envió un recordatorio';
$string['privacy:metadata:facetoface_signups:notificationtype'] = 'Como le gustaría al usuario ser notificado';
$string['privacy:metadata:facetoface_signups:sessionid'] = 'La ID de la sesión';
$string['privacy:metadata:facetoface_signups_status'] = 'El Estado de una pre-inscripción de usuario a una sesión';
$string['privacy:metadata:facetoface_signups_status:grade'] = 'La calificación asignada por asistir a la sesión';
$string['privacy:metadata:facetoface_signups_status:note'] = 'Almacena la razón para una sesión cancelada';
$string['privacy:metadata:facetoface_signups_status:signupid'] = 'La ID de la pre-inscripción';
$string['privacy:metadata:facetoface_signups_status:statuscode'] = 'El estado de la pre-inscripción; por ejemplo, cancelada, declinada, completamente_asistida';
$string['privacy:metadata:facetoface_signups_status:timecreated'] = 'La hora cuando fue creada la pre-inscripción.';
$string['privacy:metadata:roleid'] = 'La ID del rol del usuario.';
$string['privacy:metadata:userid'] = 'La ID del usuario que accedió a la actividad Cara-a-Cara';
$string['really'] = '¿realmente quiere eliminar todos los resultados para esta Cara-a-Cara?';
$string['registeredon'] = 'Registrada En';
$string['registrations'] = 'Registros';
$string['reminder'] = 'Recordatorio';
$string['reminderinstrmngr'] = '# Avisopara Mánager';
$string['reminderinstrmngr_help'] = 'Cuando **Mandar aviso a mánager** está activado, el texto en el **Aviso para Mánager** es enviado al mánager del estudiante, avisándole que ha sido apuntados para una sesión Cara-a-Cara.';
$string['remindermessage'] = 'Mensaje recordatorio';
$string['remindermessage_help'] = 'Este mensaje es enviado unos cuantos días antes de la fecha de inicio de una sesión.';
$string['reminderperiod'] = 'Cuantos días antes se envía el mensaje';
$string['reminderperiod_help'] = 'El mensaje reocrdatorio se enviará este número de días antes de la fecha de inicio de la sesión.';
$string['requestmessage'] = 'Mensaje de solicitud';
$string['requestmessage_help'] = 'Cuando está habilitado **Requerir aprobación** , la sección de **Mensaje de solicitud** está disponible.

La sección de **Mensaje de solicitud** muestra los avisos enviados al estudiante y a sus mánagers respecto al proceso de aprobación para que el alumno asista a una sesión Cara-a-Cara.

**Asunto:** es la línea del asunto que aparece en los Emails de solicitud de aprobación enviados al mánager y al estudiante.

**Mensaje:** es el texto del Email enviado al estudiante para avisarle que su solicitud para asistir a la sesión Cara-a-Cara ha sido enviada a su mánager para aprobación.

**Aviso para el mánager:** es el texto del Email esnviiado al mánager del alumno en el cual se le solicita su aprobación para asistir a la sesión Cara-a-Cara.';
$string['room'] = 'Sala';
$string['room_help'] = '**Sala** es el nombre/número/identificador de la sala que se usa para la sesión de entrenamiento.

La **Sala** se muestra en la página de \'Inscripción\', la de \'Ver todas las sesiones\' y en todas las notificaciones por Email.';
$string['saveallfeedback'] = 'Guardar todas las respuestas';
$string['saveattendance'] = 'Guardar asistencia';
$string['scheduledsession'] = 'Sesión agendada';
$string['scheduledsessions'] = 'Sesiones agendadas';
$string['search:activity'] = 'Actividades cara-a-cara';
$string['seatsavailable'] = 'Asientos disponibles';
$string['seeattendees'] = 'Ver asistentes';
$string['sentremindermanager'] = 'Se envió Email  recordatorio al mánager del usuario';
$string['sentreminderuser'] = 'Se envió Email  recordatorio al usuario';
$string['sessiondate'] = 'La fecha de la sesión es la fecha en la cual ocurrirá la sesión.';
$string['sessiondateandtime'] = '{$a->startdatetime} - {$a->enddatetime} (time zone: {$a->timezone})';
$string['sessiondatetime'] = 'Fecha/hora de sesión';
$string['sessiondatetimeknown'] = 'Fecha/hora de sesión conocida';
$string['sessiondatetimeknown_help'] = '**Si es que se conoce la fecha/hora de una sesión**

Cuando se pone "Si" en esta configuración, se mostrarán la fecha y hora de la sesión en la página del curso (si la sesión futura está disponible), en la página de \'Ver todos los cursos\', la página de apuntarse a la sesión y en todas las notificaciones por Email relacionadas con la sesión.

Cuando un miembro del staff se apunta para una sesión con fecha y hora conocida:

* Al miembro del staff y a su mánager se les enviará un Email de confirmación (por ejemplo, el formateado según la sección de "Mensaje de confirmación" de las configuraciones de la instancia de Cara-a-Cara.
* Al miembro del staff se le enviará un mensaje Email recordatorio (por ejemplo, el formateado según la sección de "Mensaje recordatorio" de las configuraciones de la instancia Cara-a-Cara. El recordatorio será enviado con un cierto número de días de anticipación, de acuerdo a la configuración de Días de anticipación para enviar el mensaje\' que también se encuentra en la sección de "Mensaje recordatorio" de las configuraciones de la instancia de Cara-a-Cara.

**Si no se conocen fecha/hora de una sesión (o en lista-de-espera)**

Si se elige "No" para esta configuración, se mostrará el texto para "en lista-de-espera" en la página del curso, la página de "Ver todas las sesiones", la página de apuntarse a la sesión, y en todos los Emails de notificaciones relacionados con la sesión.

Cuando un miembro del staff se apunta para una sesión en lista-de-espera:

* Al miembro del staff se le enviará un Email de confirmación (por ejemplo, el formateado de acuerdo a a la sección de "Mensaje para lista-de-espera" de las configuraciones de la instancia de Cara-a-Cara.
* Al miembro del staff no se le enviará un mensaje Email recordatorio.
* Al mánager del miembro del staff no se le enviarán mensajes Email de confirmación ni de cancelación.';
$string['sessionfinishtime'] = 'Hora de término de sesión';
$string['sessioninprogress'] = 'sesión en progreso';
$string['sessionisfull'] = 'La sesión ya está llena. Usted necesitará elegir otro horario o hablar con el instructor.';
$string['sessionnumber'] = '#';
$string['sessionover'] = 'sesión terminada';
$string['sessionrequiresmanagerapproval'] = 'Esta sesión requiere de aprobación por el mánager para reservarse.';
$string['sessionroles'] = 'Roles de la sesión';
$string['sessions'] = 'Sesiones';
$string['sessionsoncoursepage'] = 'Sesiones mostradas en la página del curso';
$string['sessionsoncoursepage_help'] = 'Este es el número de sesiones para cada actividad Cara-a-Cara que se mostrarán en la página principal del curso';
$string['sessionstartdate'] = 'Fecha de inicio de sesión';
$string['sessionstarttime'] = 'Hora de inicio de sesión';
$string['sessionvenue'] = 'Sitio de la sesión';
$string['setting:addchangemanageremail'] = 'Pedirles a los usuarios las direcciones de Email de sus mánagers.';
$string['setting:addchangemanageremail_caption'] = 'Email del mánager:';
$string['setting:addchangemanageremaildefault'] = 'Pedirles a los usuarios las direcciones de Email de sus mánagers.';
$string['setting:attendeesexportfields'] = 'Seleccionar los campos a ser incluidos en una lista de asistentes de sesión exportados. Esto será adicionalmente al nombre y apellidos de los asistentes.';
$string['setting:attendeesexportfields_caption'] = 'Campos de exportación de asistentes';
$string['setting:cancelrestriction'] = 'Tiempo mínimo antes de una sesión cuando el estudiante puede cancelar su reservación. Dentro de este período no están permitidas las cancelaciones.';
$string['setting:cancelrestriction_caption'] = 'Restricción de cancelación';
$string['setting:defaultcancellationinstrmngr'] = 'Mensaje por defecto para cancelación que se envía a los mánagers.';
$string['setting:defaultcancellationinstrmngr_caption'] = 'Mensaje de cancelación (mánagers)';
$string['setting:defaultcancellationinstrmngrdefault'] = '*** Aviso solamente ****

Esto es para avisarle que [nombre] [apellidos] ya no está apuntado para el curso siguiente y lo nombró a Usted como su Mánager / Líder del Equipo.

*** la cancelación de la reservación de [nombre] [apellidos] se copia debajo ****';
$string['setting:defaultcancellationmessage'] = 'Mensaje por defecto para cancelación que se envía al usuario.';
$string['setting:defaultcancellationmessage_caption'] = 'Mensaje por cancelación';
$string['setting:defaultcancellationmessagedefault'] = 'Este mensaje es para avisarle que su reservación para el curso siguiente ha sido cancelada:

***RESERVACIÓN CANCELADA***

Participante: [nombre] [apellidos]
Curso: [nombrecaraacara]
Duración: [duracion]
Fecha(s): [todaslasfechas]

Lugar: [session::location]
Sitio: [session:venue]
Sala: [session:room]';
$string['setting:defaultcancellationsubject'] = 'Línea del asunto para Emails de cancelación.';
$string['setting:defaultcancellationsubject_caption'] = 'Asunto de cancelación';
$string['setting:defaultcancellationsubjectdefault'] = 'Cancelación de reservación de curso';
$string['setting:defaultconfirmationinstrmngr'] = 'Mensaje por defecto para confirmación que se envía a los mánagers.';
$string['setting:defaultconfirmationinstrmngr_caption'] = 'Mensaje de confirmación (mánagers)';
$string['setting:defaultconfirmationinstrmngrdefault'] = '*** Aviso solamente ****

Esto es para avisarle que [nombre] [apellidos] ha sido apuntado para el curso siguiente y lo nombró a Usted como su Mánager / Líder del Equipo.

Si Usted no es su Mánager / Líder del Equipo y cree que ha recibido este Email por error, por favor responda a este correo. Si tiene dudas respecto a que sus miembros del staff tomen este curso, por favor discútalo con ellos directamente.

*** la confirmación de la reservación de [nombre] [apellidos] se copia debajo ****';
$string['setting:defaultconfirmationmessage'] = 'Mensaje por defecto para confirmación que se envía a los usuarios.';
$string['setting:defaultconfirmationmessage_caption'] = 'Mensaje de confirmación';
$string['setting:defaultconfirmationmessagedefault'] = 'Este mensaje es para confirmarle que Usted está reservado en el curso siguiente:

Participante: [nombre] [apellidos]
Curso: [nombrecaraacara]
Costo: [costo]

Duración: [duracion]
Fecha(s): [todaslasfechas]

Lugar: [session:location]
Sitio: [session:venue]
Sala: [session:room]

***Por favor llegue diez minutos antes de que empiece el curso***

Para re-agendar o cancelar su reservación:
Para re-agendar su reservación Usted necesitará cancelar esta reservación y entonces volver a reservar una nueva sesión. Para cancelar su reservación, regrese al sitio, vaya a la página de este curso y seleccione \'cancelar\' en la pantalla sobre información de reservación.

[detalles]

Usted recibirá un recordatorio [periodorecordatorio] días hábiles antes de que inicie el curso.';
$string['setting:defaultconfirmationmessagedefault2'] = '<p><b>¡Gracias por apuntarse!</b></p>';
$string['setting:defaultconfirmationsubject'] = 'Línea de asunto para Emails de confirmación';
$string['setting:defaultconfirmationsubject_caption'] = 'Asunto de confirmación';
$string['setting:defaultconfirmationsubjectdefault'] = 'Confirmación de reservación de Curso:
[nombrecaraacara], [horainicio]-[horafin], [fechasesion]';
$string['setting:defaultreminderinstrmngr'] = 'Mensaje recordatorio por defecto que se envía a los mánagers';
$string['setting:defaultreminderinstrmngr_caption'] = 'Mensaje recordatorio (mánagers)';
$string['setting:defaultreminderinstrmngrdefault'] = '*** Recordatorio solamente ****

Esto es para recordarle que [nombre] [apellidos] está reservado para asistir al curso siguiente y también ha recibido este Email de confirmación.

Si Usted no es su Mánager / Líder del Equipo y cree que ha recibido este Email por error, por favor responda a este correo.

*** El Email recordatorio de [nombre] [apellidos] se copia debajo ****';
$string['setting:defaultremindermessage'] = 'Mensaje recordatorio por defecto que se envía a los usuarios';
$string['setting:defaultremindermessage_caption'] = 'Mensaje recordatorio';
$string['setting:defaultremindermessagedefault'] = 'Este es un recordatorio de que Usted está reservado en el curso siguiente:

Participante: [nombre] [apellidos]
Curso: [nombrecaraacara]
Costo: [costo]

Duración: [duracion]
Fecha(s): [todaslasfechas]

Lugar: [session:location]
Sitio: [session:venue]
Sala: [session:room]

***Por favor llegue diez minutos antes de que empiece el curso***

Para re-agendar o cancelar su reservación:
Para re-agendar su reservación Usted necesitará cancelar esta reservación y entonces volver a reservar una nueva sesión. Para cancelar su reservación, regrese al sitio, vaya a la página de este curso y seleccione \'cancelar\' en la pantalla sobre información de reservación.

[detalles]';
$string['setting:defaultremindersubject'] = 'Linea de asunto por defecto de Emails recordatorios.';
$string['setting:defaultremindersubject_caption'] = 'Asunto de Recordatorio';
$string['setting:defaultremindersubjectdefault'] = 'Recordatorio de reservación de curso:
[nombrecaraacara], [horainicio]-[horafin], [fechasesion]';
$string['setting:defaultrequestinstrmngrdefault'] = 'Esto es para avisarle de que [nombre] [apellidos] ha solicitado ser reservado al curso siguiente, y Usted está enlistado como su Líder de Equipo / Mánager.

Curso: [nombrecaraacara]
Costo: [costo]

Duración: [duracion]
Fecha(s): [todaslasfechas]

Lugar: [session:location]
Sitio: [session:venue]
Sala: [session:room]

Por favor siga en enlace siguiente para aprobar la solicitud:
[enlaceasistentes]#unapproved

*** La solicitud de reservación de [nombre] [apellidos] se copia debajo ****';
$string['setting:defaultrequestmessagedefault'] = 'Su solicitud para reservar el siguiente curso ha sido enviada a su mánager.

Participante: [nombre] [apellidos]
Curso: [nombrecaraacara]
Costo: [costo]

Duración: [duracion]
Fecha(s): [todaslasfechas]

Lugar: [session:location]
Sitio: [session:venue]
Sala: [session:room]';
$string['setting:defaultrequestsubjectdefault'] = 'Solicitud de reservación de curso: [nombrecaraacara], [horainicio]-[horafin]';
$string['setting:defaultvalue'] = 'Valor por defecto';
$string['setting:defaultwaitlistedmessage'] = 'Mensaje de lista-de-espera por defecto que se envía a los usuarios.';
$string['setting:defaultwaitlistedmessage_caption'] = 'Mensaje de lista-de-espera';
$string['setting:defaultwaitlistedmessagedefault'] = 'Esto es para avisarle de que  Usted ha sido añadido a la lista-de-espera para:

Curso: [nombrecaraacara]
Lugar: [session:location]
Participante: [nombre] [apellidos]

***Por favor tenga en cuenta que esta NO es una confirmación de reservación de curso***

Al ponerse en lista-de-espera Usted ha manifestado su interés en este curso y se le contactará directamente cuando las sesiones estén disponibles.

Para quitarse a Usted mismo de la lista-de-espera, por favor regrese a este curso y elija \'Cancelar reservación\'. Por favor tenga en cuenta que NO hay Email que confirme que lo removieron de lista-de-espera.';
$string['setting:defaultwaitlistedsubject'] = 'Línea de asunto para Emails de lista-de-espera';
$string['setting:defaultwaitlistedsubject_caption'] = 'Asunto de lista-de-espera';
$string['setting:defaultwaitlistedsubjectdefault'] = 'Aviso de lista-de-espera para [nombrecaraacara]';
$string['setting:disableicalcancel'] = 'Desabilitar Emails de cancelación con un archivo anexo de iCalendar';
$string['setting:disableicalcancel_caption'] = 'Deshabilitar cancelaciones de iCalendar:';
$string['setting:enableapprovals'] = 'Cuando está deshabilitado, la opción para añadir aprobaciones vía la configuración de la actividad ya no está disponible.';
$string['setting:enableapprovals_caption'] = 'Habilitar aprobaciones del mánager:';
$string['setting:fromaddress'] = 'Qué aparecerá en el campo \'De\' (remitente) de los recordatorios por Email enviados por este módulo.';
$string['setting:fromaddress_caption'] = 'Dirección del remitente:';
$string['setting:fromaddressdefault'] = 'moodle@ejemplo.com.mx';
$string['setting:hidecost'] = 'Ocultar los campos de costo y código de descuento.';
$string['setting:hidecost_caption'] = 'Ocultar costo y descuento:';
$string['setting:hidediscount'] = 'Ocultar solamente el campo del código de descuento.';
$string['setting:hidediscount_caption'] = 'Ocultar descuento:';
$string['setting:isfilter'] = 'Mostrar como un filtro';
$string['setting:limit_candidates'] = 'Limitar candidatos a usuarios inscritos en cursos';
$string['setting:limit_candidates_caption'] = 'Limitar candidatos';
$string['setting:manageraddressformat'] = 'Sufijo que debe estar presente en la dirección del Email del mánager para que se considere válida.';
$string['setting:manageraddressformat_caption'] = 'Sufijo requerido:';
$string['setting:manageraddressformatdefault'] = '';
$string['setting:manageraddressformatreadable'] = 'Descripción breve de las restricciones en las direcciones de Email de los mánagers. Esta configuración no tiene efecto si la configuración anterior no se activó.';
$string['setting:manageraddressformatreadable_caption'] = 'Ejemplo de formato:';
$string['setting:manageraddressformatreadabledefault'] = 'nombre.apellido@empresa.com';
$string['setting:oneemailperday'] = 'mandar múltiples Emails de confirmación para los eventos multi-días.';
$string['setting:oneemailperday_caption'] = 'Un mensaje por día:';
$string['setting:possiblevalues'] = 'Lista de valores posibles';
$string['setting:sessionroles'] = 'Los usuarios asignados a los roles seleccionados en un curso pueden rastrearse con cada sesión Cara-a-Cara';
$string['setting:sessionroles_caption'] = 'Roles de sesión';
$string['setting:showinsummary'] = 'Mostrar en exportaciones';
$string['setting:type'] = 'Tipo de campo';
$string['shortname'] = '# Nombre corto';
$string['shortname_help'] = '**Nombre corto** es la descripción de la sesión que aparece en el calendario de entrenamiento cuando está habilitado **Mostrar en el calendario**';
$string['showbylocation'] = 'Mostrar por lugar';
$string['showoncalendar'] = 'Configuraciones para mostrar el calendario';
$string['showoncalendar_help'] = 'Cuando se selecciona **Sitio** las sesiones de actividad de Cara-a-Cara se mostrarán en el calendario del sitio como un Evento Global. Todos los usuarios del sitio podrán ver estas sesiones.

Cuando se selecciona **Curso**, todas las sesiones de actividad Cara-a-Cara se mostrarán en el calendario del curso y aparecerán como Eventos del Curso en el calendario a nivel del sitio, y serán visibles para todos los usuarios inscritos en el curso.

Cuando se selecciona **Ninguno**, las sesiones de actividad Cara-a-Cara solamente se mostrarán como Eventos del Usuario en el calendario de un asistente confirmado, siempre y cuando se haya seleccionado la opción de **Mostrar en el Calendario del Usuario**.';
$string['sign-ups'] = 'Apuntados';
$string['signup'] = 'Apuntarse';
$string['signupfor'] = 'Apuntarse para {$a}';
$string['signupforsession'] = 'Apuntarse para una sesión futura disponible';
$string['signupforstream'] = 'Apuntarse al canal';
$string['signupforthissession'] = 'Apuntarse para esta sesión Cara-a-Cara';
$string['signups'] = 'Apuntados';
$string['signuptype'] = 'Tipo de apuntarse';
$string['signuptype_help'] = 'Cuando se configura a "Único", un estudiante solamente puede registrarse para una sesión para actividad Cara-a-Cara. Cuando se configura a "múltiple" un estudiante puede registrarse para múltiples sesiones por actividad.';
$string['signuptypemismatch'] = 'El  tipo de apuntado debe ser "múltiple" cuando el método de apuntarse es por actividad.';
$string['single'] = 'Único';
$string['sitenoticesheading'] = 'Avisos del sitio';
$string['somesessionsfull'] = 'Usted no ha sido apuntado para algunas sesiones en el canal porque ya están a su capacidad máxima.';
$string['status'] = 'Estatus';
$string['status_approved'] = 'Aprobado';
$string['status_booked'] = 'Reservado';
$string['status_declined'] = 'Declinado';
$string['status_fully_attended'] = 'Completamente lleno';
$string['status_no_show'] = 'No show';
$string['status_partially_attended'] = 'Parcialmente asistido';
$string['status_requested'] = 'Solicitado';
$string['status_session_cancelled'] = 'Sesión cancelada';
$string['status_user_cancelled'] = 'Cancelada por usuario';
$string['status_waitlisted'] = 'Lista-de-espera';
$string['subject'] = 'Cambio en reservación en el curso {$a->coursename} ({$a->duedate})';
$string['submissions'] = 'Envíos';
$string['submit'] = 'Enviar';
$string['submitted'] = 'Enviado';
$string['summary'] = 'Resumen';
$string['suppressemail'] = 'Suprimir notificaciones por Email';
$string['suppressemail_help'] = 'Use esta opción si desea remover silenciosamente usuarios de una sesión Cara-a-Cara. Cuando esta opción se activa, no se envían los mensajes Email de confirmación habituales a los usuarios seleccionados.';
$string['takeattendance'] = 'Tomar lista';
$string['thirdpartyemailaddress'] = 'Dirección(es) de Email de tercera(s) persona(s)';
$string['thirdpartyemailaddress_help'] = '**Direcciones de terceras personas** es un campo opcional usado para especificar la dirección Email de una tercera persona (como un instructor externo) quien entonces recibirá mensajes de confirmación siempre que un usuario se apunte para una sesión.
Cuando se escriban **múltiples direcciones Email**, separe las direcciones con comas. Por ejemplo: hugo@ejemplo.com.mx,paco@ejemplo.com.mx,luis@ejemplo.com.mx';
$string['thirdpartywaitlist'] = 'Notificar a terceras personas sobre sesiones con lista-de-espera';
$string['thirdpartywaitlist_help'] = 'Cuando se selecciona **Notificar a terceras personas acerca de sesiones en lista-de-espera**, las terceras personas serán notificadas cuando un estudiante se apunte para una sesión en lista-de-espera.

Cuando no se habilita el  **Notificar a terceras personas acerca de sesiones en lista-de-espera**, las terceras personas no serán notificadas cuando un usuario se apunte a (o cancele) una sesión agendada.';
$string['time'] = 'Hora';
$string['timecancelled'] = 'Hora cancelada';
$string['timedue'] = 'Fecha límite para registrarse';
$string['timefinish'] = 'Hora de término';
$string['timefinish_help'] = 'Hora de término es cuando se termina la sesión.';
$string['timerequested'] = 'Hora en que fue solicitada';
$string['timesignedup'] = 'Hora en que fue apuntada';
$string['timestart'] = 'Hora de inicio';
$string['timestart_help'] = 'Hora de inicio es cuando se inicia la sesión.';
$string['unapprovedrequests'] = 'Solicitudes NO aprobadas';
$string['unknowndate'] = '(fecha desconocida)';
$string['unknowntime'] = '(hoora desconocida)';
$string['upcomingsessions'] = 'Sesiones futuras';
$string['upcomingsessionslist'] = 'Lista de todas las sesiones futuras para esta actividad Cara-a-Cara';
$string['updaterequests'] = 'Actualizar solicitudes';
$string['upgradeinfofacetoface'] = '{$a}: Información de actualización de Face to Face';
$string['upgradeprocessinggrades'] = 'Procesando calificaciones de Cara-a-Cara; esto puede tomar un rato si hubiera muchas sesiones...';
$string['uploadbookings'] = 'Subir reservaciones';
$string['usercalentry'] = 'Mostrar entrada en el calendario del usuario';
$string['usercalentry_help'] = 'Cuando se active esta configuración, se añade una entrada de Evento de Usuario al calendario de un asistente a una sesión Cara-a-Cara. Cuando se desactiva, esto impide que aparezca un evento duplicado en el calendario de sesión de usuario, donde Usted tenga configurado el mostrar calendario en Curso o Sitio.';
$string['usercancelledon'] = 'El usuario canceló en {$a}';
$string['userdeletedcancel'] = 'El usuario ha sido eliminado';
$string['usernotsignedup'] = 'Estatus: sin apuntarse';
$string['usersignedup'] = 'Estatus: apuntado';
$string['usersignedupon'] = 'El usuario se apuntó en {$a}';
$string['userwillbewaitlisted'] = 'Esta sesión actualmente está llena. Al elegir el botón de "Apuntarse", Usted será puesto en la lista-de-espera de la sesión.';
$string['validation:needatleastonedate'] = 'Usted necesita proporcionar al menos una fecha o marcar la sesión como en-lista-de-espera.';
$string['venue'] = 'Sitio';
$string['venue_help'] = '**Sitio** es el edificio en donde se llevará a cabo la sesión (edificio 2, Facultad de Medicina, Auditorio Simón Bolivar, Biblioteca de Humanidades, etc).

El **Sitio** se muestra en la página de \'Registro\', la página de \'Ver todo\' y en todas las notificaciones por correo electrónico.';
$string['viewallsessions'] = 'Ver todas las sesiones';
$string['viewsubmissions'] = 'Ver envíos';
$string['wait-list'] = 'Lista-de-espera';
$string['wait-listed'] = 'En lista-de-espera';
$string['waitlistedmessage'] = 'Mensaje en-lista -de-espera';
$string['waitlistedmessage_help'] = 'Este mensaje se manda cuando los usuarios se apuntan para una sesión en lista-de-espera.';
$string['waitliststatus'] = 'Usted tiene un lugar en la lista-de-espera de la sesión siguiente';
$string['xhours'] = '{$a} horas';
$string['xminutes'] = '{$a} minutos';
$string['youarebooked'] = 'Usted está reservado para la siguiente sesión';
$string['youremailaddress'] = 'Su dirección Email';
