<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_preg', language 'es_mx', version '4.4'.
 *
 * @package     qtype_preg
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept_leaf_control'] = '';
$string['answerno'] = 'Respuesta {$a}';
$string['answersinstruct'] = '<p>Ingrese (al menos una) expresiones regulares en la notación seleccionada como respuestas. Si se da una respuesta correcta, debería de concordar al menos con una expresión regular con 100% de calificación.</p><p>Usted puede usar remplazables (placeholders) como por ejemplo {$0} en la retroalimentación para insertar partes capturadas de una respuesta del estudiante. {$0} será remplazado por la concordancia completa , {$1} será remplazado por la concordancia del primer subpatrón, etc. Si el motor elegido no soporta captura de subpatrón Usted debería de usar solamente  {$0}.</p>';
$string['any_leaf_control'] = '';
$string['anycrlf_leaf_control'] = '';
$string['approximatematch'] = 'Detección de errores tipográficos';
$string['approximatematch_help'] = 'La Detección de errores tipográficos proporciona coincidencias con insensibilidad para algunos errores. Si el buscador de coincidencias encuentra errores, la coincidencia se vuelve parcial.';
$string['assertfailmodeasis'] = 'Rápido';
$string['assertfailmodedescription'] = 'El modo completo le permite al motor autómata de estado finito trabajar 100% correctamente con aseveraciones simples y permite el soporte para aseveraciones complejas, pero trabaja aproximadamente 2 veces más lentamente que el modo rápido. El modo rápido raramente dará una pista equivocada en regexes complejos con aseveraciones  \\b o  \\B.';
$string['assertfailmodelabel'] = 'Modo de soporte de aseveración';
$string['assertfailmodemerge'] = 'Completo';
$string['authoring_form_charset_flags'] = 'significado real (formato unificado)';
$string['authoring_form_charset_mode'] = 'Modo de visualización para clases de caracteres complejos';
$string['authoring_form_charset_userinscription'] = 'como se escribe en expresiones regulares';
$string['authoring_form_check_strings'] = 'Revisar la(s) cadena(s)';
$string['authoring_form_edit_header'] = 'Expresión regular';
$string['authoring_form_edit_header_help'] = 'Escriba su regex aquí. Usted verá el árbol de sintaxis correspondiente, la gráfica explicativa y descripción. Haga clic en "Guardar cambios" para aplicar cambios en el regex.';
$string['authoring_form_graph_build'] = 'Construyendo la gráfica ...';
$string['authoring_form_options_header'] = 'Opciones de concordancia';
$string['authoring_form_options_header_help'] = 'Aquí puede Usted afinar la concordancia (coincidencia). Estas opciones se guardarán en el formato de edición de la pregunta.';
$string['authoring_form_page_header'] = 'Constructor regex';
$string['authoring_form_rect_selection_mode'] = 'Modo de selección de rectángulo';
$string['authoring_form_rect_selection_select'] = 'Seleccionar';
$string['authoring_form_testing_header'] = 'Prueba de expresión regular';
$string['authoring_form_testing_header_help'] = 'Aquí puede escribir algunas cadenas de caracteres (una por línea) para probar su regex. Después de hacer clic en "Revisar la(s) cadena(s)", Usted verá resultados a la derecha; las partes concordantes son verdes, las partes que no concuerdan son rojas. Un ícono muestra si es que la cadena de caracteres dada coincidió con todo el regex (palomita de color verde) o no (cruz roja).';
$string['authoring_form_testing_textarea'] = 'Escriba las cadenas para ver coincidencia (una por línea)';
$string['authoring_form_text'] = 'Escriba su regex aquí:';
$string['authoring_form_tooltip'] = 'Abrir constructor regex';
$string['authoring_form_tree_build'] = 'Construyendo el árbol ...';
$string['backref_intersection'] = 'El uso de retroreferencias con aseveraciones todavía no está soportado.';
$string['backreforrecursionforapproximate'] = 'Retro-referencias o recursión para concordarcia con detección de errores tipográficos';
$string['bsr_anycrlf_leaf_control'] = '';
$string['bsr_unicode_leaf_control'] = '';
$string['c_at_end_of_pattern_node_error'] = 'Error de sintaxis: \\c al final del patrón';
$string['callout_big_number_node_error'] = 'El número {$a->addinfo} en la llamada es demasiado grande, no debería de ser mayor de 255';
$string['capital_esc_z_leaf_assert'] = 'fin de la cadena';
$string['char_code_disallowed_node_error'] = 'Los puntos de código Unicode 0xd800 ... 0xdfff ahora están permitidos';
$string['char_code_too_big_node_error'] = 'El código del caracter {$a->addinfo} es demasiado grande';
$string['charhintpenalty'] = 'Castigo para la pista de la letra siguiente';
$string['charhintpenalty_help'] = 'Castigo por obtener la pista de una-letra. Típicamente será mayor que el castigo de pregunta habitual de Moodle (que aplica a cualquier intento de pregunta para contestar pregunta sin pistas). Estos castigos son mutuamente exclusivos.';
$string['circumflex_leaf_assert'] = 'inicio de la cadena';
$string['collapsed_node'] = 'subexpresión colapsada';
$string['commit_leaf_control'] = '';
$string['condsubexpr_assert_expected_node_error'] = 'Aseveración o condición esperada';
$string['condsubexpr_too_much_alter_node_error'] = 'Error de sintaxis: demasiadas alternancias de nivel superior en la subexpresión condicional en posición desde {$a->colfirst} hasta {$a->collast}. Use paréntesis si desea incluir alternancias en expresiones-si (yes-expr) o expresiones-no (no-expr).';
$string['condsubexpr_zero_condition_node_error'] = 'Condición inválida (?(0)';
$string['correctanswer'] = 'Respuesta correcta';
$string['correctanswer_help'] = 'Escriba una respuesta correcta (no una expresión regular) para mostrar a los estudiantes. Si lo deja vacío, el motor de coincidencia tratará de generar una respuesta correcta por sí mismo, poniendo atención a obtener la más cercana a la respuesta del estudiante. Por ahora solamente el motor autómata de estado finito puede generar respuestas correctas.';
$string['cr_leaf_control'] = '';
$string['crlf_leaf_control'] = '';
$string['cx_should_be_ascii_node_error'] = '\\c debería de ser seguida por un caracter ASCII';
$string['debugheading'] = 'Configuraciones para depurar (debug)';
$string['defaultenginedescription'] = 'Motor coincidente seleccionado por defecto al crear pregunta nueva';
$string['defaultenginelabel'] = 'Motor coincidente por defecto';
$string['defaultlangdescription'] = 'Idioma seleccionado por defecto al crear pregunta nueva';
$string['defaultlanglabel'] = 'Idioma por defecto';
$string['defaultnotationdescription'] = 'Notación seleccionada por defecto al crear pregunta nueva';
$string['defaultnotationlabel'] = 'Notación por defecto';
$string['define_node_cond_subexpr'] = '"define"-subexpresión condicional';
$string['description_accept_leaf_control'] = 'forzar coincidencia de subexpresión exitosa';
$string['description_any_leaf_control'] = 'alimentación de línea coincide con alguna secuencia de línea nueva Unicode';
$string['description_anycrlf_leaf_control'] = 'alimentación de línea coincide con retorno de carro, alimentación de línea o retorno de carro seguido por alimentación de línea';
$string['description_bsr_anycrlf_leaf_control'] = '\\R coincide con CR (retorno de carro), LF (alimentación de línea), o CRLF (Retorno de carro con alimentación de línea)';
$string['description_bsr_unicode_leaf_control'] = '\\R coincide con cualquier secuencia de línea nueva Unicode';
$string['description_capital_esc_z_leaf_assert'] = 'fin de la cadena';
$string['description_char'] = '<span class="text-info" class=\'font-family:"Courier New", Courier, monospace;\'>{$a->char}</span>';
$string['description_char0'] = 'caracter nulo (NUL)';
$string['description_char1'] = 'caracter inicio de encabezado (SOH)';
$string['description_char10'] = 'caracter de escape de enlace de datos (DLE)';
$string['description_char11'] = 'caracter de control de dispositivo 1 (DC4) (a menudo XON)';
$string['description_char12'] = 'caracter de control de dispositivo 2 (DC2)';
$string['description_char13'] = 'caracter de control de dispositivo 3 (DC3) (a menudo XOFF)';
$string['description_char14'] = 'caracter de control de dispositivo 4 (DC4)';
$string['description_char15'] = 'caracter de reconocimiento negativo (NAK)';
$string['description_char16'] = 'caracter ocioso sincrónico (SYN)';
$string['description_char17'] = 'caracter de fin del bloque de transmisión (ETB)';
$string['description_char18'] = 'caracter cancelar (CAN)';
$string['description_char19'] = 'caracter fin de medio (EM)';
$string['description_char1A'] = 'caracter sustituto (SUB)';
$string['description_char1B'] = 'escape (ESC)';
$string['description_char1C'] = 'caracter separador de archivo (FS)';
$string['description_char1D'] = 'caracter separador de grupo (GS)';
$string['description_char1E'] = 'caracter separador de registro (RS)';
$string['description_char1F'] = 'caracter separador de unidad (US)';
$string['description_char2'] = 'caracter inicio de texto (STX)';
$string['description_char20'] = 'espacio';
$string['description_char2002'] = 'espacio en';
$string['description_char2003'] = 'espacio em';
$string['description_char2009'] = 'espacio angosto';
$string['description_char200C'] = 'no-unión de ancho cero';
$string['description_char200D'] = 'unión de ancho cero';
$string['description_char3'] = 'caracter fin de texto (ETX)';
$string['description_char4'] = 'caracter fin de transmisión (EOT)';
$string['description_char5'] = 'caracter de interrogación (Enquiry=ENQ)';
$string['description_char6'] = 'Caracter de confirmación (Acknowledgement=ACK)';
$string['description_char7'] = 'caracter de timbre (BEL)';
$string['description_char7F'] = 'caracter suprimir (Delete=DEL)';
$string['description_char8'] = 'caracter retroceso (BS)';
$string['description_char9'] = 'tabulación (HT)';
$string['description_charA'] = 'alimentación de línea (LF)';
$string['description_charA0'] = 'espacio no-separable';
$string['description_charAD'] = 'caracter de guión suave';
$string['description_charB'] = 'tabulación vertical (VT)';
$string['description_charC'] = 'alimentación de formato (FF)';
$string['description_charD'] = 'caracter de retorno de carro (CR)';
$string['description_charE'] = 'caracter shift out (SO)';
$string['description_charF'] = 'caracter shift in (SI)';
$string['description_char_16value'] = 'caracter con código 0x{$a->code}';
$string['description_charflag_Arabic'] = 'Caracter arábigo';
$string['description_charflag_Arabic_neg'] = 'caracter no-arábigo';
$string['description_charflag_Armenian'] = 'Caracter armenio';
$string['description_charflag_Armenian_neg'] = 'Caracter no-armenio';
$string['description_charflag_Avestan'] = 'Caracter avestan';
$string['description_charflag_Avestan_neg'] = 'Caracter no-avestan';
$string['description_charflag_Balinese'] = 'Caracter balinés';
$string['description_charflag_Balinese_neg'] = 'Caracter no-balinés';
$string['description_charflag_Bamum'] = 'Caracter banum';
$string['description_charflag_Bamum_neg'] = 'Caracter no-banum';
$string['description_charflag_Bengali'] = 'Caracter bengalí';
$string['description_charflag_Bengali_neg'] = 'Caracter no-bengalí';
$string['description_charflag_Bopomofo'] = 'Caracter bopomofo';
$string['description_charflag_Bopomofo_neg'] = 'Caracter no-bopomofo';
$string['description_charflag_Braille'] = 'caracter Braille';
$string['description_charflag_Braille_neg'] = 'caracter no-Braille';
$string['description_charflag_Buginese'] = 'Caracter buginés';
$string['description_charflag_Buginese_neg'] = 'caracter no-Buginés';
$string['description_charflag_Buhid'] = 'Caracter buhid';
$string['description_charflag_Buhid_neg'] = 'caracter no-Buhid';
$string['description_charflag_C'] = 'otra propiedad Unicode';
$string['description_charflag_C_neg'] = 'no es otra propiedad Unicode';
$string['description_charflag_Canadian_Aboriginal'] = 'Caracter aborígen canadiense';
$string['description_charflag_Canadian_Aboriginal_neg'] = 'caracter no-Aborígeno Canadiense';
$string['description_charflag_Carian'] = 'Caracter cariano';
$string['description_charflag_Carian_neg'] = 'caracter no-Cariano';
$string['description_charflag_Cc'] = 'control';
$string['description_charflag_Cc_neg'] = 'no-control';
$string['description_charflag_Cf'] = 'formato';
$string['description_charflag_Cf_neg'] = 'no-formato';
$string['description_charflag_Cham'] = 'Caracter cham';
$string['description_charflag_Cham_neg'] = 'caracter no-Cham';
$string['description_charflag_Cherokee'] = 'Caracter cheroki';
$string['description_charflag_Cherokee_neg'] = 'caracter no-Cherokee';
$string['description_charflag_Cn'] = 'no asignado';
$string['description_charflag_Cn_neg'] = 'no sin-asignar';
$string['description_charflag_Co'] = 'uso privado';
$string['description_charflag_Co_neg'] = 'no uso-privado';
$string['description_charflag_Common'] = 'Caracter común';
$string['description_charflag_Common_neg'] = 'no es un caracter Común';
$string['description_charflag_Coptic'] = 'Caracter cóptico';
$string['description_charflag_Coptic_neg'] = 'caracter no-Cóptico';
$string['description_charflag_Cs'] = 'sustituto';
$string['description_charflag_Cs_neg'] = 'no surrogado';
$string['description_charflag_Cuneiform'] = 'Caracter cuneiforme';
$string['description_charflag_Cuneiform_neg'] = 'caracter no-Cuneiforme';
$string['description_charflag_Cypriot'] = 'Caracter chipriota';
$string['description_charflag_Cypriot_neg'] = 'caracter no-Cipriota';
$string['description_charflag_Cyrillic'] = 'Caracter cirílico';
$string['description_charflag_Cyrillic_neg'] = 'caracter no-Cirílico';
$string['description_charflag_Deseret'] = 'Caracter Deseret';
$string['description_charflag_Deseret_neg'] = 'caracter no-Deseret';
$string['description_charflag_Devanagari'] = 'Caracter devanagari';
$string['description_charflag_Devanagari_neg'] = 'Caracter no-devanagari';
$string['description_charflag_Egyptian_Hieroglyphs'] = 'Caracter jeroglífico egipcio';
$string['description_charflag_Egyptian_Hieroglyphs_neg'] = 'Caracter no-jeroglífico-egipcio';
$string['description_charflag_Ethiopic'] = 'Caracter etiope';
$string['description_charflag_Ethiopic_neg'] = 'caracter no-Etiope';
$string['description_charflag_Georgian'] = 'Caracter georgiano';
$string['description_charflag_Georgian_neg'] = 'caracter no-Georgiano';
$string['description_charflag_Glagolitic'] = 'Caracter glagolítico';
$string['description_charflag_Glagolitic_neg'] = 'Caracter no-glagolítico';
$string['description_charflag_Gothic'] = 'Caracter gótico';
$string['description_charflag_Gothic_neg'] = 'caracter no-Gótico';
$string['description_charflag_Greek'] = 'Caracter griego';
$string['description_charflag_Greek_neg'] = 'caracter no-Griego';
$string['description_charflag_Gujarati'] = 'Caracter gujarati';
$string['description_charflag_Gujarati_neg'] = 'caracter no-Gujarati';
$string['description_charflag_Gurmukhi'] = 'Caracter gurmukhi';
$string['description_charflag_Gurmukhi_neg'] = 'Caracter no-gurmukhi';
$string['description_charflag_Han'] = 'Caracter han';
$string['description_charflag_Han_neg'] = 'caracter no-Han';
$string['description_charflag_Hangul'] = 'Caracter hangul';
$string['description_charflag_Hangul_neg'] = 'Caracter no-hangul';
$string['description_charflag_Hanunoo'] = 'Caracter hanunoo';
$string['description_charflag_Hanunoo_neg'] = 'Caracter no-hanunoo';
$string['description_charflag_Hebrew'] = 'Caracter hebreo';
$string['description_charflag_Hebrew_neg'] = 'caracter no Hebreo';
$string['description_charflag_Hiragana'] = 'Caracter hiragana';
$string['description_charflag_Hiragana_neg'] = 'Caracter no-hiragana';
$string['description_charflag_Imperial_Aramaic'] = 'Caracter arameo imperial';
$string['description_charflag_Imperial_Aramaic_neg'] = 'Caracter no-arameo-imperial';
$string['description_charflag_Inherited'] = 'caracter heredado';
$string['description_charflag_Inherited_neg'] = 'caracter no heredado';
$string['description_charflag_Inscriptional_Pahlavi'] = 'Caracter pahlavi inscripcional';
$string['description_charflag_Inscriptional_Pahlavi_neg'] = 'Caracter no-pahlavi-inscripcional';
$string['description_charflag_Inscriptional_Parthian'] = 'Caracter parthian inscripcional';
$string['description_charflag_Inscriptional_Parthian_neg'] = 'Caracter no-parthian-inscripcional';
$string['description_charflag_Javanese'] = 'Caracter javanés';
$string['description_charflag_Javanese_neg'] = 'caracter no-Javanés';
$string['description_charflag_Kaithi'] = 'Caracter kaithi';
$string['description_charflag_Kaithi_neg'] = 'Caracter no-kaithi';
$string['description_charflag_Kannada'] = 'Caracter Kannada';
$string['description_charflag_Kannada_neg'] = 'Caracter no-Kannada';
$string['description_charflag_Katakana'] = 'Caracter katakana';
$string['description_charflag_Katakana_neg'] = 'Caracter no-katakana';
$string['description_charflag_Kayah_Li'] = 'caracter Kayah Li';
$string['description_charflag_Kayah_Li_neg'] = 'caracter no-Kayah-Li';
$string['description_charflag_Kharoshthi'] = 'caracter Kharoshthi';
$string['description_charflag_Kharoshthi_neg'] = 'caracter no-Kharoshthi';
$string['description_charflag_Khmer'] = 'Caracter Khmer';
$string['description_charflag_Khmer_neg'] = 'Caracter no-Khmer';
$string['description_charflag_L'] = 'letra';
$string['description_charflag_L_neg'] = 'no letra';
$string['description_charflag_Lao'] = 'caracter lao';
$string['description_charflag_Lao_neg'] = 'caracter no-lao';
$string['description_charflag_Latin'] = 'caracter latino';
$string['description_charflag_Latin_neg'] = 'caracter no Latino';
$string['description_charflag_Lepcha'] = 'caracter Lepcha';
$string['description_charflag_Lepcha_neg'] = 'caracter no-Lepcha';
$string['description_charflag_Limbu'] = 'Caracter limbu';
$string['description_charflag_Limbu_neg'] = 'Caracter no-limbu';
$string['description_charflag_Linear_B'] = 'caracter lineal B';
$string['description_charflag_Linear_B_neg'] = 'caracter no-lineal-B';
$string['description_charflag_Lisu'] = 'caracter lisu';
$string['description_charflag_Lisu_neg'] = 'caracter no-lisu';
$string['description_charflag_Ll'] = 'letra minúscula';
$string['description_charflag_Ll_neg'] = 'no es letra minúscula';
$string['description_charflag_Lm'] = 'letra modificadora';
$string['description_charflag_Lm_neg'] = 'no es letra modificadora';
$string['description_charflag_Lo'] = 'otra letra';
$string['description_charflag_Lo_neg'] = 'no es otra letra';
$string['description_charflag_Lt'] = 'letra de Título';
$string['description_charflag_Lt_neg'] = 'no es letra de Título';
$string['description_charflag_Lu'] = 'letra MAYÚSCULA';
$string['description_charflag_Lu_neg'] = 'no es letra MAYÚSCULA';
$string['description_charflag_Lycian'] = 'caracter liciano';
$string['description_charflag_Lycian_neg'] = 'caracter no-liciano';
$string['description_charflag_Lydian'] = 'caracter lyndian';
$string['description_charflag_Lydian_neg'] = 'caracter no-lyndian';
$string['description_charflag_M'] = 'marca';
$string['description_charflag_M_neg'] = 'no es signo';
$string['description_charflag_Malayalam'] = 'Caracter malayalam';
$string['description_charflag_Malayalam_neg'] = 'Caracter no-malayalam';
$string['description_charflag_Mc'] = 'marca que espacía';
$string['description_charflag_Mc_neg'] = 'no es marca que espacía';
$string['description_charflag_Me'] = 'signo que encierra';
$string['description_charflag_Me_neg'] = 'no es signo que encierra';
$string['description_charflag_Meetei_Mayek'] = 'Caracter meetel mayek';
$string['description_charflag_Meetei_Mayek_neg'] = 'Caracter no-meetel-mayek';
$string['description_charflag_Mn'] = 'signo que no espacía';
$string['description_charflag_Mn_neg'] = 'no es un signo no-espaciador';
$string['description_charflag_Mongolian'] = 'Caracter mongol';
$string['description_charflag_Mongolian_neg'] = 'no es un caracter mongólico';
$string['description_charflag_Myanmar'] = 'Caracter myanmar';
$string['description_charflag_Myanmar_neg'] = 'Caracter no-myanmar';
$string['description_charflag_N'] = 'número';
$string['description_charflag_N_neg'] = 'no es número';
$string['description_charflag_Nd'] = 'número decimal';
$string['description_charflag_Nd_neg'] = 'no es número decimal';
$string['description_charflag_New_Tai_Lue'] = 'Caracter nuevo Tai Lu';
$string['description_charflag_New_Tai_Lue_neg'] = 'Caracterno Nuevo Tai Lu';
$string['description_charflag_Nko'] = 'Caracter Nko';
$string['description_charflag_Nko_neg'] = 'Caracter no-Nko';
$string['description_charflag_Nl'] = 'número en letra';
$string['description_charflag_Nl_neg'] = 'número no-letra';
$string['description_charflag_No'] = 'otro número';
$string['description_charflag_No_neg'] = 'no es otro número';
$string['description_charflag_Ogham'] = 'Caracter ogham';
$string['description_charflag_Ogham_neg'] = 'Caracter no-Nko';
$string['description_charflag_Ol_Chiki'] = 'caracter Ol_Chiki';
$string['description_charflag_Ol_Chiki_neg'] = 'caracter no-Ol_Chiki';
$string['description_charflag_Old_Italic'] = 'caracter itálico antiguo';
$string['description_charflag_Old_Italic_neg'] = 'caracter no-itálico-antiguo';
$string['description_charflag_Old_Persian'] = 'caracter persa antiguo';
$string['description_charflag_Old_Persian_neg'] = 'caracter no-persa-antiguo';
$string['description_charflag_Old_South_Arabian'] = 'Caracter antiguo Sud_Arábigo';
$string['description_charflag_Old_South_Arabian_neg'] = 'Caracter no Antiguo Sud_Arábigo';
$string['description_charflag_Old_Turkic'] = 'caracter turco antiguo';
$string['description_charflag_Old_Turkic_neg'] = 'Caracteer no Antiguo_Turco';
$string['description_charflag_Oriya'] = 'Caracter Oriya';
$string['description_charflag_Oriya_neg'] = 'Caracter no Oriya';
$string['description_charflag_Osmanya'] = 'Caracter Osmanya';
$string['description_charflag_Osmanya_neg'] = 'Caracter no Osmanya';
$string['description_charflag_P'] = 'puntuación';
$string['description_charflag_P_neg'] = 'no es puntuación';
$string['description_charflag_Pc'] = 'puntuación conectora';
$string['description_charflag_Pc_neg'] = 'no es puntuación conectora';
$string['description_charflag_Pd'] = 'puntuación guión';
$string['description_charflag_Pd_neg'] = 'no es puntuación guión';
$string['description_charflag_Pe'] = 'puntuación de cierre';
$string['description_charflag_Pe_neg'] = 'no es puntuación de cierre';
$string['description_charflag_Pf'] = 'puntuación final';
$string['description_charflag_Pf_neg'] = 'no es puntuación final';
$string['description_charflag_Phags_Pa'] = 'Caracter Phags_Pa';
$string['description_charflag_Phags_Pa_neg'] = 'Caracter no Phags_Pa';
$string['description_charflag_Phoenician'] = 'caracter fenicio';
$string['description_charflag_Phoenician_neg'] = 'Caracter no Fenicio';
$string['description_charflag_Pi'] = 'puntuación inicial';
$string['description_charflag_Pi_neg'] = 'no es puntuación inicial';
$string['description_charflag_Po'] = 'otra puntuación';
$string['description_charflag_Po_neg'] = 'no es otra puntuación';
$string['description_charflag_Ps'] = 'puntuación abierta';
$string['description_charflag_Ps_neg'] = 'no es puntuación abierta';
$string['description_charflag_Rejang'] = 'Caracter rejang';
$string['description_charflag_Rejang_neg'] = 'Caracter no-rejang';
$string['description_charflag_Runic'] = 'caracter rúnico';
$string['description_charflag_Runic_neg'] = 'caracter no-rúnico';
$string['description_charflag_S'] = 'símbolo';
$string['description_charflag_S_neg'] = 'no es símbolo';
$string['description_charflag_Samaritan'] = 'Caracter samaritano';
$string['description_charflag_Samaritan_neg'] = 'Caracter no-samaritano';
$string['description_charflag_Saurashtra'] = 'Caracter saurashtra';
$string['description_charflag_Saurashtra_neg'] = 'Caracter no-saurashtra';
$string['description_charflag_Sc'] = 'símbolo de divisa';
$string['description_charflag_Sc_neg'] = 'no es símbolo de divisa';
$string['description_charflag_Shavian'] = 'caracter shaviano';
$string['description_charflag_Shavian_neg'] = 'caracter no-shaviano';
$string['description_charflag_Sinhala'] = 'caracter sinhala';
$string['description_charflag_Sinhala_neg'] = 'caracter no-sinhala';
$string['description_charflag_Sk'] = 'símbolo modificador';
$string['description_charflag_Sk_neg'] = 'no es símbolo modificador';
$string['description_charflag_Sm'] = 'símbolo matemático';
$string['description_charflag_Sm_neg'] = 'no es un símbolo matemático';
$string['description_charflag_So'] = 'otro símbolo';
$string['description_charflag_So_neg'] = 'no es otro símbolo';
$string['description_charflag_Sundanese'] = 'caracter sudanés';
$string['description_charflag_Sundanese_neg'] = 'caracter no-sudanés';
$string['description_charflag_Syloti_Nagri'] = 'Caracter Syloti_Nagri';
$string['description_charflag_Syloti_Nagri_neg'] = 'Caracter no Syloti_Nagri';
$string['description_charflag_Syriac'] = 'Caracter Sirio';
$string['description_charflag_Syriac_neg'] = 'Caracter no Sirio';
$string['description_charflag_Tagalog'] = 'Caracter tagalog';
$string['description_charflag_Tagalog_neg'] = 'Caracter Tagalog';
$string['description_charflag_Tagbanwa'] = 'Caracter no Tagalog';
$string['description_charflag_Tagbanwa_neg'] = 'Caracter no Tagbanwa';
$string['description_charflag_Tai_Le'] = 'Caracter Tai_Le';
$string['description_charflag_Tai_Le_neg'] = 'Caracter no Tai_Le';
$string['description_charflag_Tai_Tham'] = 'Caracter Tai_Tham';
$string['description_charflag_Tai_Tham_neg'] = 'Caracter no Tai_Tham';
$string['description_charflag_Tai_Viet'] = 'Caracter Tai_Viet';
$string['description_charflag_Tai_Viet_neg'] = 'Caracter no Tai_Viet';
$string['description_charflag_Tamil'] = 'Caracter tamil';
$string['description_charflag_Tamil_neg'] = 'Caracter no Tamil';
$string['description_charflag_Telugu'] = 'Caracter Telugu';
$string['description_charflag_Telugu_neg'] = 'Caracter no Telugu';
$string['description_charflag_Thaana'] = 'Caracter Thaana';
$string['description_charflag_Thaana_neg'] = 'Caracter no Thaana';
$string['description_charflag_Thai'] = 'Caracter Thai';
$string['description_charflag_Thai_neg'] = 'Caracter no Thai';
$string['description_charflag_Tibetan'] = 'Caracter tibetano';
$string['description_charflag_Tibetan_neg'] = 'Caracter no Tibetano';
$string['description_charflag_Tifinagh'] = 'Caracter Tifinagh';
$string['description_charflag_Tifinagh_neg'] = 'Caracter no Tifinagh';
$string['description_charflag_Ugaritic'] = 'Caracter Ugaritic';
$string['description_charflag_Ugaritic_neg'] = 'Caracter no Ugaritic';
$string['description_charflag_Vai'] = 'Caracter vai';
$string['description_charflag_Vai_neg'] = 'Caracter no Vai';
$string['description_charflag_Xan'] = 'cualquier caracter alfanumérico';
$string['description_charflag_Xan_neg'] = 'no es cualquier caracter alfanumérico';
$string['description_charflag_Xps'] = 'cualquier caracter de espacio POSIX';
$string['description_charflag_Xps_neg'] = 'cualquier caracter no de espacio POSIX';
$string['description_charflag_Xsp'] = 'cualquier caracter de espacio Perl';
$string['description_charflag_Xsp_neg'] = 'no es cualquier caracter de espacio Perl';
$string['description_charflag_Xwd'] = 'cualquier caracter de "palabra" Perl';
$string['description_charflag_Xwd_neg'] = 'no es cualquier caracter de "palabra" Perl';
$string['description_charflag_Yi'] = 'Caracter Yi';
$string['description_charflag_Yi_neg'] = 'Caracter no Yi';
$string['description_charflag_Z'] = 'separador';
$string['description_charflag_Z_neg'] = 'no es separador';
$string['description_charflag_Zl'] = 'separador de línea';
$string['description_charflag_Zl_neg'] = 'no es separador de línea';
$string['description_charflag_Zp'] = 'separador de párrafo';
$string['description_charflag_Zp_neg'] = 'no es separador de párrafo';
$string['description_charflag_Zs'] = 'separador de espacio';
$string['description_charflag_Zs_neg'] = 'no es separador de espacio';
$string['description_charflag_alnum'] = 'una letra o dígito';
$string['description_charflag_alnum_neg'] = 'no-letra y no-dígito';
$string['description_charflag_alpha'] = 'una letra';
$string['description_charflag_alpha_neg'] = 'no-es-una-letra';
$string['description_charflag_ascii'] = 'un caracter con códigos 0-127';
$string['description_charflag_ascii_neg'] = 'no es un un caracter con códigos 0-127';
$string['description_charflag_blank'] = 'solamente un espacio o tabulación';
$string['description_charflag_blank_neg'] = 'no es espacio ni tabulación';
$string['description_charflag_cntrl'] = 'un caracter de control';
$string['description_charflag_cntrl_neg'] = 'no es un caracter de control';
$string['description_charflag_digit'] = 'un dígito decimal';
$string['description_charflag_digit_neg'] = 'no es un dígito decimal';
$string['description_charflag_dot'] = 'cualquier caracter';
$string['description_charflag_graph'] = 'un caracter imprimible (excluyendo espacio)';
$string['description_charflag_graph_neg'] = 'no es un caracter imprimible (excluyendo espacio)';
$string['description_charflag_lower'] = 'una letra minúscula';
$string['description_charflag_lower_neg'] = 'no es letra minúscula';
$string['description_charflag_print'] = 'un caracter imprimible (incluyendo espacio)';
$string['description_charflag_print_neg'] = 'no es un caracter imprimible (incluyendo espacio)';
$string['description_charflag_punct'] = 'un caracter imprimible (excluyendo letras, dígitos y espacio)';
$string['description_charflag_punct_neg'] = 'no es un caracter imprimible (excluyendo letras, dígitos y espacio)';
$string['description_charflag_slashd'] = 'un dígito decimal';
$string['description_charflag_slashd_neg'] = 'no es dígito decimal';
$string['description_charflag_slashh'] = 'un caracter de espacio blanco horizontal';
$string['description_charflag_slashh_neg'] = 'no es un caracter de espacio blanco horizontal';
$string['description_charflag_slashs'] = 'un espacio blanco';
$string['description_charflag_slashs_neg'] = 'no es un espacio blanco';
$string['description_charflag_slashv'] = 'un caracter de espacio blanco vertical';
$string['description_charflag_slashv_neg'] = 'no es un caracter de espacio blanco vertical';
$string['description_charflag_slashw'] = 'un caracter de palabra';
$string['description_charflag_slashw_neg'] = 'no es un caracter de palabra';
$string['description_charflag_space'] = 'un espacio blanco';
$string['description_charflag_space_neg'] = 'no es un espacio blanco';
$string['description_charflag_upper'] = 'una letra MAYÚSCULA';
$string['description_charflag_upper_neg'] = 'no es una letra MAYÚSCULA';
$string['description_charflag_word'] = 'un caracter palabra';
$string['description_charflag_word_neg'] = 'no es un caracter palabra';
$string['description_charflag_xdigit'] = 'un dígito hexadecimal';
$string['description_charflag_xdigit_neg'] = 'no es un dígito hexadecimal';
$string['description_charset'] = 'uno de los caracteres siguientes: {$a->characters};';
$string['description_charset_neg'] = 'cualquier caracter exceptuando los siguientes: {$a->characters};';
$string['description_charset_neg_one'] = 'no {$a->characters}';
$string['description_charset_range'] = 'cualquier caracter {$a}';
$string['description_circumflex_leaf_assert'] = 'inicio de la cadena';
$string['description_commit_leaf_control'] = 'si el resto del patón no concuerda - falla general, sin avance del punto de inicio';
$string['description_cr_leaf_control'] = 'línea-nueva concuerda con solamente retorno-de-carro';
$string['description_crlf_leaf_control'] = 'línea-nueva concuerda con retorno-de-carro seguido por avance-de-línea';
$string['description_define_node_cond_subexpr'] = 'definición de {$a->firstoperand}';
$string['description_dollar_leaf_assert'] = 'fin de la cadena';
$string['description_duplicate_node_subexpr'] = 'agrupamiento (re-iniciar números de grupo para capturar grupos en cada alternancia): [ {$a->firstoperand} ]';
$string['description_empty_leaf_meta'] = 'nada';
$string['description_errorafter'] = '</span>';
$string['description_errorbefore'] = '<span style="color:red">';
$string['description_esc_a_leaf_assert'] = 'inicio de la cadena';
$string['description_esc_b_leaf_assert'] = 'un límite de palabra';
$string['description_esc_b_leaf_assert_neg'] = 'no es un límite de palabra';
$string['description_esc_g_leaf_assert'] = 'primer posición concordante en la cadena';
$string['description_fail_leaf_control'] = 'forzar falla';
$string['description_grouping_node_subexpr'] = 'agrupando: [ {$a->firstoperand} ]';
$string['description_leaf_backref'] = 'texto concordado por subpatrón #{$a}';
$string['description_leaf_backref_name'] = 'texto concordado por subpatrón "{$a}"';
$string['description_leaf_options'] = '{$a}:';
$string['description_leaf_subexpr_call'] = 'llamada del subpatrón #{$a}';
$string['description_leaf_subexpr_call_all'] = 'llamada de la expresión regular completa';
$string['description_leaf_subexpr_call_all_recursive'] = 'llamada recursiva de la exresión regular completa';
$string['description_leaf_subexpr_call_name'] = 'llamada del subpatrón "{$a}"';
$string['description_leaf_subexpr_call_name_recursive'] = 'llamada recursiva del subpatrón "{$a}"';
$string['description_leaf_subexpr_call_recursive'] = 'llamada recursiva del subpatrón #{$a}';
$string['description_leaf_template'] = 'plantilla sin parámetros';
$string['description_lf_leaf_control'] = 'línea nueva coincide con alimentación de línea solamente';
$string['description_mark_name_leaf_control'] = 'ajustar nombre a {$a->name} a ser pasado de regreso';
$string['description_nla_node_assert'] = 'el texto posterior no debería de concordar: [{$a->firstoperand}]';
$string['description_nla_node_assert_cond'] = 'el texto posterior no concuerda: [{$a->firstoperand}]';
$string['description_nlb_node_assert'] = 'el texto precedente no debería de concordar: [{$a->firstoperand}]';
$string['description_nlb_node_assert_cond'] = 'el texto precedente no concuerda: [{$a->firstoperand}]';
$string['description_no_start_opt_leaf_control'] = 'sin optimización inicio-concordar (start-match)';
$string['description_node_alt'] = '{$a->firstoperand} o {$a->secondoperand}';
$string['description_node_alt_wcomma'] = '{$a->firstoperand} o {$a->secondoperand}';
$string['description_node_concat'] = '{$a->firstoperand} después {$a->secondoperand}';
$string['description_node_concat_and'] = '{$a->firstoperand} y {$a->secondoperand}';
$string['description_node_concat_short'] = '{$a->firstoperand}{$a->secondoperand}';
$string['description_node_concat_space'] = '{$a->firstoperand} {$a->secondoperand}';
$string['description_node_concat_wcomma'] = '{$a->firstoperand} después {$a->secondoperand}';
$string['description_node_cond_subexpr'] = 'if {$a->cond} entonces revisar: [{$a->firstoperand}]{$a->else}';
$string['description_node_cond_subexpr_else'] = 'caso contrario revisar: [{$a->secondoperand}]';
$string['description_node_finite_quant'] = '{$a->firstoperand} repetido desde {$a->leftborder} hasta {$a->rightborder} veces {$a->greedy}';
$string['description_node_finite_quant_0'] = '{$a->firstoperand} repetido ni más de  {$a->rightborder} veces o faltante{$a->greedy}';
$string['description_node_finite_quant_01'] = '{$a->firstoperand} puede estar faltándole {$a->greedy}';
$string['description_node_finite_quant_1'] = '{$a->firstoperand} repetido no más de {$a->rightborder} veces {$a->greedy}';
$string['description_node_finite_quant_borders_err'] = '(bordes cuantificadores incorrectos)';
$string['description_node_finite_quant_strict'] = '{$a->firstoperand} repetido {$a->leftborder} veces {$a->greedy}';
$string['description_node_infinite_quant'] = '{$a->firstoperand} repetido al menos {$a->leftborder} veces{$a->greedy}';
$string['description_node_infinite_quant_0'] = '{$a->firstoperand} repetido cualquier número de veces o faltándole{$a->greedy}';
$string['description_node_infinite_quant_1'] = '{$a->firstoperand} repetido cualquier número de veces{$a->greedy}';
$string['description_node_template'] = 'plantilla con parámetros';
$string['description_onceonly_node_subexpr'] = 'una vez revisado subpatrón #{$a->number}: [ {$a->firstoperand} ]';
$string['description_onceonly_node_subexpr_name'] = 'una vez revisado subpatrón "{$a->name} #{$a->number}": [ {$a->firstoperand} ]';
$string['description_operand'] = 'operando';
$string['description_option_J'] = 'permitir nombres duplicados';
$string['description_option_U'] = 'cuantificadores no avariciosos por defecto';
$string['description_option_i'] = 'sin importar MAY/minúsculas';
$string['description_option_m'] = 'concordancia multilínea';
$string['description_option_s'] = 'metacaracter punto concuerda con \\n';
$string['description_option_x'] = 'los espacios blancos en la expresión se ignoraron';
$string['description_pla_node_assert'] = 'el texto siguiente debería concordar con: [{$a->firstoperand}]';
$string['description_pla_node_assert_cond'] = 'el texto siguiente concuerda con: [{$a->firstoperand}]';
$string['description_plb_node_assert'] = 'el texto precedente debería concordar con: [{$a->firstoperand}]';
$string['description_plb_node_assert_cond'] = 'el texto precedente concuerda con: [{$a->firstoperand}]';
$string['description_prune_leaf_control'] = 'si el resto del patrón no concuerda - avanzar al siguiente caracter inicial';
$string['description_quant_greedy'] = '';
$string['description_quant_lazy'] = '(cuantificador flojo)';
$string['description_quant_possessive'] = '(cuantificador posesivo)';
$string['description_range'] = 'desde {$a->start} hasta {$a->end}';
$string['description_recursion_node_cond_subexpr'] = 'el patrón #{$a->number} está en concordancia recursiva';
$string['description_recursion_node_cond_subexpr_all'] = 'todo el patrón está en concordancia recursiva';
$string['description_recursion_node_cond_subexpr_name'] = 'el patrón "{$a->name}" está en concordancia recursiva';
$string['description_skip_leaf_control'] = 'si el resto del patrón no concuerda - avanzar a posición de concordancia actual';
$string['description_skip_name_leaf_control'] = 'si el resto del patrón no concuerda - avanzar a (*MARK:{$a})';
$string['description_small_esc_z_leaf_assert'] = 'fin de la cadena';
$string['description_subexpr_node_cond_subexpr'] = 'el subpatrón #{$a->number} ha sido concordado exitosamente';
$string['description_subexpr_node_cond_subexpr_name'] = 'el subpatrón "{$a->name}" ha sido concordado exitosamente';
$string['description_subexpr_node_cond_subexpr_wrapper'] = 'si {$a->cond} entonces revisar: [{$a->firstoperand}]{$a->else}';
$string['description_subexpr_node_subexpr'] = 'subpatrón #{$a->number}: [ {$a->firstoperand} ]';
$string['description_subexpr_node_subexpr_name'] = 'subpatrón "{$a->name}" #{$a->number}: [ {$a->firstoperand} ]';
$string['description_template_brackets_opt'] = 'texto dentro de paréntesis cuadrados o faltantes';
$string['description_template_brackets_req'] = 'texto dentro de paréntesis cuadrados';
$string['description_template_custom_parens_opt'] = 'texto dentro de paréntesis personalizados opcionales o sin';
$string['description_template_custom_parens_req'] = 'texto dentro de paréntesis personalizados opcionales';
$string['description_template_integer'] = 'cualquier número incluyendo + o -';
$string['description_template_parens_opt'] = 'texto en paréntesis redondos o faltantes';
$string['description_template_parens_req'] = 'texto en paréntesis redondos';
$string['description_template_word'] = 'cualquier palabra';
$string['description_then_leaf_control'] = 'si el resto del patrón no concuerda - retroceder a la siguiente alternación';
$string['description_tool'] = 'Descripción';
$string['description_tool_help'] = 'Aquí puede ver una descripción de su expresión regular. Al oprimir el nodo del árbol se resalta la sub-gráfica correspondiente y también se marca la parte correspondiente de la descripción con un color amarillo.';
$string['description_ucp_leaf_control'] = 'PCRE_UCP';
$string['description_unsetoption_J'] = 'no-permitir nombres duplicados';
$string['description_unsetoption_U'] = 'cuantificadores avariciosos por defecto';
$string['description_unsetoption_i'] = 'sensible minús/MAYÚS';
$string['description_unsetoption_m'] = 'sin concordancia multilínea';
$string['description_unsetoption_s'] = 'metacaracter punto no concuerda con \\n';
$string['description_unsetoption_x'] = 'los espacios blancos en la expresión no fueron ignorados';
$string['description_utf16_leaf_control'] = 'modo UTF-16';
$string['description_utf8_leaf_control'] = 'modo UTF-8';
$string['different_subexpr_names_node_error'] = 'Diferentes nombres de subpatrones para subpatrones del mismo número';
$string['dollar_leaf_assert'] = 'fin de la cadena';
$string['doterror'] = 'No se puede sacar {$a->name} para este regex';
$string['duplicate_subexpr_names_node_error'] = 'Dos subpatrones nombrados tienen el mismo nombre';
$string['empty_fa'] = 'No pudo concordarse ninguna cadena de caracteres por esta expresión regular (el autómata finito está vacío).';
$string['empty_leaf_meta'] = 'vacío';
$string['engine'] = 'Motor de concordancia';
$string['engine_heading_descriptions'] = 'El concordar expresiones regulares puede consumir mucho tiempo y memoria. Estas configuraciones le permiten controlar límites de uso de  tiempo y memoria por los motores de concordancia. Auméntelos si obtiene mensajes de que la expresión regular es demasiado compleja, pero atienda también el desempeño de su servidor (también podría querer aumentar los límites de tiempo y memoria PHP). Disminúyalos si le da una página vacía al guardar o correr una pregunta preg.';
$string['engine_help'] = '<p>No hay un \'mejor\' motor de concordancia, por loq ue puede elegir el motor que se adapte mejor a la pregunta en particular.</p><p>Nativo <b>Motor de concordancia preg PHP</b> funciona usando la función preg_match() del lenguaje PHP. Es casi 100% libre de problemas y puede trabajar con sintaxis competa PCRE, pero no puede soportar características avanzadas (mostrar concordancias parciales y pistas).</p><p><b>Motor de concordancia FA</b> usa código de concordancia personalizado. Soporta concordancia parcial y pistas,pero no soporta \'lookaround assertions\' (se le notificará cuando intente guardar una pregunt con expresiones no soportadas) y potencialmente podría tener problemas.</p><p>Si las diferencias entre motores es demasiado complicada para Usted, simplemente pruébelos todos  para ver como es que sus capacidades se adaptan a sus necesidades. Si un motor falla en una pregunta, entonces intente otros motores para ver si la manejan mejor.</p><p>El motor FA probablemente es la mejor elección para Usted si no emplea \'lookaround assertions\' (https://campusvirtual.ull.es/ocw/pluginfile.php/2301/mod_resource/content/0/perlexamples/node59.html ).</p>';
$string['error_PCREincorrectregex'] = 'Expresión regular incorrecta - ¡Error de sintaxis! Consulte <a href="http://pcre.org/pcre.txt">PCRE documentation</a> para más información.';
$string['error_duringauthoringtool'] = 'Hubo errores al tratar de construir {$a}:';
$string['error_infiniterecursion'] = 'Regex contiene recursividad infinita';
$string['esc_a_leaf_assert'] = 'inicio de la cadena';
$string['esc_b_leaf_assert'] = 'un límite de palabra';
$string['esc_g_leaf_assert'] = 'la primera posición concordante en la cadena';
$string['exactmatch'] = 'Concordancia exacta';
$string['exactmatch_help'] = '<p>Por defecto, la concordancia (coincidencia) de expresión regular regresa verdadero (\'\'true\'\') si hay al menos una concordancia (coincidencia) en la cadena de caracteres (respuesta) dada.</p><p>Configure esto a Si (\'\'Yes\'\'), si Usted escribe expresiones regulares para respuestas completas de estudiantes. El configurar esto a No le da a Usted flexibilidad  adicional; Usted puede especificar una respuesta con calificación baja (o cero) para pescar errores comunes y dar comentarios al respecto. Usted todavía puede especificar concordancias (coincidencias) exactas para algunas de sus expresiones regulares si comienzan con ^ y terminan con $.</p>';
$string['explain_any_char'] = 'Cualquier caracter de';
$string['explain_any_char_except'] = 'Cualquier caracter excepto';
$string['explain_begin'] = 'empezar';
$string['explain_define'] = 'PORHACER';
$string['explain_end'] = 'fin';
$string['explain_false'] = 'falso';
$string['explain_parameter'] = 'parámetro';
$string['explain_true'] = 'cierto';
$string['explain_unknow_meta'] = 'meta desconocida';
$string['explain_unknow_template'] = 'plantilla desconocida';
$string['explaining_graph_tool'] = 'Gráfica explicativa';
$string['explaining_graph_tool_help'] = 'Aquí puede ver una gráfica explicativa. Al oprimir el nodo del árbol se marca la sub-gráfica correspondiente con rectángulo verde oscuro. También puede seleccionar varios nodos a la vez dentro de un rectángulo al habilitar la casilla para modo de selección Rectángulo.';
$string['fa_matcher'] = 'Autómata de estado finito';
$string['fa_settings_heading'] = 'Configuraciones del motor del autómata de estado finito';
$string['fa_simulation_state_limit'] = 'Límites de simulación del autómata: estados';
$string['fa_simulation_state_limit_description'] = 'Al concordar una cadena de caracteres con un regex que contenga retro-referencias (backreferences) o recursión, puede ser alcanzado un estado FA usando rutas diferentes. Esto significa que hay varios "estados de simulación" creados para un "estado estructural". Esta configuración le permite a Usted controlar el número total de esos estados de simulación.';
$string['fa_state_limit'] = 'Límite del tamaño del autómata: estados';
$string['fa_state_limit_description'] = 'Número máximo de estados en FA. Afina los límites de tiempo y memoria para el motor FA al concordar regexes complejos';
$string['fa_transition_limit'] = 'Límite del tamaño del autómata: transiciones';
$string['fa_transition_limit_description'] = 'Número máximo de transiciones en FA. Optimiza el tiempo y los límites de memoria para el motor FA al concordar regexes complejos.';
$string['fail_leaf_control'] = '';
$string['greedyquant'] = 'Cuantificadores avariciosos';
$string['grouping_node_subexpr'] = 'agrupamiento';
$string['groupspaircountoverlimit'] = 'Posible número de pares de grupos en paso sencillo de rebose del algoritmo dre revisión de equivalencia del autómata. Este límite es necesario para proteger de duración prolongada de comparación. Pídale a su administrador del sitio que cambie las configuraciones si fuera necesario.';
$string['hintcolouredstring'] = 'parte concordada de la respuesta';
$string['hintgradeborder'] = 'Límite de calificación para pista';
$string['hintgradeborder_help'] = 'Las respuestas con calificación menor que el límite de calificación para pista no se usarán para dar pistas.';
$string['hinthowtofixpic'] = 'como corregir respuesta';
$string['hinting'] = 'Opciones para pistas';
$string['hinting_help'] = 'Las opciones para pistas le permiten configurar disponibilidad y penalizaciones para varias pistas.';
$string['hintnextchar'] = 'siguiente caracter correcto';
$string['hintnextlexem'] = 'siguiente {$a} correcto/a';
$string['howtofixpichintpenalty'] = 'Penalización para  pista para como corregir imagen';
$string['howtofixpichintpenalty_help'] = 'Penalización para  pista para como corregir imagen';
$string['incorrect_charset_range_node_error'] = 'Rango de caracter incorrecto en posición desde  {$a->colfirst} hasta {$a->collast}:el caracter izquierdo es  "mayor que" el derecho';
$string['incorrect_quant_range_node_error'] = 'Rango calificador incorrecto en posición desde  {$a->colfirst} hasta {$a->collast}: el borde (límite) izquierdo es mayor que el derecho';
$string['langselect'] = 'Idioma (lenguaje)';
$string['langselect_help'] = 'Para la siguiente pista de lexema, Usted debería elegir un idioma/lenguaje, que es usado para descomponer las respuestas en lexemas. Cada lenguaje/idioma tiene sus propias reglas para lexemas. Los lenguajes/idiomas están definidos usando el (bloque de lenguajes formales) \'Formal languages block\'';
$string['lazyquant'] = 'Cuantificadores flojos';
$string['lazyquantforapproximate'] = 'Cuantificadores flojos para concordancia aproximada con detección de errores tipográficos';
$string['leaf_assert'] = 'aseveración simple';
$string['leaf_backref'] = 'retroreferencia';
$string['leaf_charset'] = 'conjunto de caracteres';
$string['leaf_charset_error'] = 'conjunto de caracteres incorrecto';
$string['leaf_charset_except'] = 'cualquier caracter exceptuando';
$string['leaf_charset_neg'] = 'conjunto de caracteres negativo';
$string['leaf_charset_one'] = 'caracter';
$string['leaf_control'] = 'secuencia de control';
$string['leaf_meta'] = 'meta-caracter o secuencia-de-escape';
$string['leaf_options'] = 'modificador';
$string['leaf_subexpr_call'] = 'llamada a subexpresión';
$string['leaf_template'] = 'plantilla sin parámetros';
$string['lexemhintpenalty'] = 'Penalización por siguiente pista de lexema';
$string['lexemhintpenalty_help'] = 'Penalización por obtener la siguiente pista de lexema. Típicamente será mayor que la penalización usual para pregunta de Moodle (la que aplica para cualquier nuevo intento para contestar pregunta sin pistas) y el caracter siguiente. Estas penalizaciones son mutuamente exclusivas.';
$string['lexemusername'] = 'Nombre visible-al-estudiante para lexema';
$string['lexemusername_help'] = 'Sus estudiantes probablemente no sabrán que una parte anatómica del idioma/lenguaje que aprenden es llamada <b>lexema</b>. Ellos podrían preferir llamarla "palabra" o "número" o de alguna otra forma. Usted puede definir un nombre para lexema que será mostrado en el botón para "Pista de lexema siguiente" aquí.';
$string['lf_leaf_control'] = '';
$string['lnu_unsupported_node_error'] = 'Las secuencias \\L, \\l, \\N{name}, \\U, y \\u no están soportadas';
$string['mark_name_leaf_control'] = '';
$string['maxerrorsshowndescription'] = 'Número máximo de errores mostrados para cada expresión regular en el formato para editar pregunta';
$string['maxerrorsshownlabel'] = 'Número máximo de errores mostrados';
$string['maxtypos'] = 'Límite de errores tipográficos';
$string['maxtypos_help'] = 'Límite superior de errores tipográficos para concordancia con detección de errores tipográficos. El exceder este número conducirá a una concordancia incorrecta.';
$string['mergedassertion_option'] = 'Usted necesita configurar el modo de aserción completa para usar aserciones positivas complejas.';
$string['mergemodeforassertion'] = 'Por favor seleccione soporte para aserción completa. en modo rápido {$a}';
$string['missing_brackets_for_g_node_error'] = '\\g no está seguido por un número/nombre reforzado, entre corchetes angulares o entrecomillado o por un número simple';
$string['missing_brackets_for_k_node_error'] = '\\k no está seguido por un número/nombre reforzado, entre corchetes angulares o entrecomillado o por un número simple';
$string['missing_callout_ending_node_error'] = 'LLamada no-cerrada';
$string['missing_close_paren_node_error'] = 'Error de sintaxis: falta paréntesis de cierre \')\' para el paréntesis de apertura en posición {$a->colfirst}';
$string['missing_comment_ending_node_error'] = 'Error de sintaxis: falta paréntesis de cierre \')\' para el comentario en posición desde{$a->colfirst} hasta {$a->collast}';
$string['missing_condsubexpr_ending_node_error'] = 'Nombre de subpatrón condicional no-cerrado';
$string['missing_control_ending_node_error'] = 'Falta paréntesis de cierre después de secuencia de control';
$string['missing_open_paren_node_error'] = 'Error de sintaxis: falta paréntesis de apertura \'(\' para el paréntesis de cierre en posición {$a->colfirst}';
$string['missing_subexpr_name_ending_node_error'] = 'Error de sintaxis en nombre del subpatrón';
$string['missing_template_close_paren_node_error'] = 'Error de sintaxis: cierre de plantilla faltante \'(?###>)\' para la plantilla de apertura en posición {$a->colfirst}';
$string['missing_template_open_paren_node_error'] = 'Error de sintaxis: apertura de plantilla faltante \'(?###name<)\' para la plantilla de cierre en posición {$a->colfirst}';
$string['nla_node_assert'] = 'Aserción lookahead negativa';
$string['nla_node_cond_subexpr'] = 'Subpatrón condicional lookahead negativo';
$string['nlb_node_assert'] = 'Aserción lookbehind negativa';
$string['nlb_node_cond_subexpr'] = 'Subpatrón condicional lookbehind negativo';
$string['no_start_opt_leaf_control'] = '';
$string['noapproximateforhowtofixpichint'] = 'El análisis de errores tipográficos y un límite de errores tipográficos arriba de 0 son requeridos. Intente habilitar la detección de errores tipográficos o configurar el límite de errores tipográficos a arriba de cero. El motor de concordancia seleccionado podría afectar la disponibilidad de la selección de errores tipográficos.';
$string['nocorrectanswermatch'] = 'Ninguna expresión regular de calificación máxima concuerda con la respuesta correcta';
$string['node_alt'] = 'alternancia';
$string['node_assert'] = 'lookaround assertion (https://campusvirtual.ull.es/ocw/pluginfile.php/2301/mod_resource/content/0/perlexamples/node59.html )';
$string['node_concat'] = 'concadenación';
$string['node_cond_subexpr'] = 'subpatrón condicional';
$string['node_error'] = 'Error de sintaxis';
$string['node_finite_quant'] = 'cuantificador finito';
$string['node_infinite_quant'] = 'cuantificador infinito';
$string['node_subexpr'] = 'subexpresión';
$string['node_template'] = 'plantilla con parámetros';
$string['nohintgradeborderpass'] = 'Ninguna respuesta tiene una calificación mayor o igual al límite de calificación para pista (\'\' hint grade border\'\'). Esto deshabilita las pistas.';
$string['nosubexprcapturing'] = 'El motor {$a} no soporta captura de subpatrones; por favor, quite los sustituibles (\'\'placeholders\'\') (excepto {$0}) de la retroalimentación o elija otro motor';
$string['notation'] = 'Notación de expresión regular';
$string['notation_help'] = '<p>Usted puede elegir la notación para ingresar expresiones regulares. Si solamente desea escribir una expresión regular, por favor use el valor por defecto, que es la notación de <b>Expresión regular </b>, la cual es muy cercana a PCRE, pero tiene capacidades adicionales a-prueba-de-errores. Ignorará los saltos de línea en sus expresiones, permitiendo un formateado leve.</p> La notación de <p><b>Expresión regular (extendida)</b> fue creada para un manejo más sencillo de expresiones más grandes. Ignorará caracteres de espacios blancos no-escapados, que no estén adentro de clases de caracteres (character class), y tratará como comentarios cualquier casa de  # no-escapados al final de la cadena de caracteres. Es equivalente a la opción PCRE_EXTENDED y al modificador PHP "x" .</p><p> La notación <b>Moodle respuesta corta</b> le permite usar preg como si fuera una pregunta Moodle de respuesta corta pero con la capacidad de dar pistas - sin que sea necesario que entienda expresiones regulares. Usted simplemente copia sus respuestas de la pregunta de respuesta corta. El comodín \'*\' está soportado.</p>';
$string['notation_mdlshortanswer'] = 'Respuesta corta de Moodle';
$string['notation_native'] = 'Expresión regular';
$string['notation_pcreextended'] = 'Expresión regular (extendida)';
$string['objectname'] = 'pregunta';
$string['onceonly_node_subexpr'] = 'subpatrón solamente-una-vez';
$string['pathtodotempty'] = 'No se puede dibujar {$a->name}: la ruta hacia dot de graphviz está vacía. Por favor pídale a su administrador que instale <a href="http://www.graphviz.com">graphviz</a> y que especifique la ruta hacia graphviz usando la opción \'pathtodot \'en Administración > Servidor > Rutas del sistema';
$string['pathtodotincorrect'] = 'No se puede dibujar {$a->name}: la ruta hacia dot de graphviz es incorrecta o no puede ejecutarse dot. Por favor pídale  a su administrador que revise si  es que <a href="http://www.graphviz.com">graphviz</a> está instalado y que la opción \'pathtodot\' sea correcta en Administración > Servidor > Rutas del sistema';
$string['php_preg_matcher'] = 'Extensión Preg PHP';
$string['pla_node_assert'] = 'aserción lookahead positiva';
$string['pla_node_cond_subexpr'] = 'subpatrón condicional lookahead positivo';
$string['plb_node_assert'] = 'aserción lookbehind positiva';
$string['plb_node_cond_subexpr'] = 'subpatrón condicional lookbehind postivo';
$string['pluginname'] = 'Expresión regular';
$string['pluginname_help'] = '<p>Expresiones regulares son una forma de patrones de escritura para concordar con diferentes cadenas de texto. Usted puede usarla para verificar respuestas en dos formas: una expresión a concordar (coincidir) con una respuesta completa (usualmente correcta), o una expresión a concordar (coincidir) con una parte de la respuesta (que puede ser usada, por ejemplo, para detectar errores comunes y dar los comentarios apropiados).
</p><p>Esta pregunta usa la sintaxis de expresiones regulares compatibles-con-perl de PHP como su notación por defecto. Hay muchos tutoriales acerca de la creación y el uso de expresiones regulares; aquí hay un: <a href="http://www.phpfreaks.com/content/print/126">ejemplo</a>. Usted puede encontrar la sintaxis detallada de expresiones regulares aquí: <a href="http://www.nusphere.com/kb/phpmanual/reference.pcre.pattern.syntax.htm">manual de PHP</a>.
Tenga en cuenta que Usted no debería de encerrar las expresiones regulares dentro de delimitadores ni tampoco especificar ningún modificador - Moodle lo hará por Usted.
</p><p>Usted también puede usar esta pregunta como la forma avanzada de respuesta-corta con pistas, ¡aún cuando usted no sepa ni jota acerca de expresiones regulares ! Simplemente seleccione  <b>Moodle respuestacorta</b> como la notación para sus preguntas.</p>';
$string['pluginname_link'] = 'question/type/preg';
$string['pluginnameadding'] = 'Añadiendo una pregunta de expresión regular';
$string['pluginnameediting'] = 'Editando una pregunta de expresión regular';
$string['pluginnamesummary'] = 'Escriba una cadena de caracteres de respuesta del estudiante  que pueda ser concordada contra varias expresiones regulares. Se muestra al estudiante la parte correcta de su respuesta. Usando comportamientos con intentos múltiples, puede proporcionarse una pista al decirle un caracter o lexema correcto siguiente.<br/>Usted puede usarlo sin saber acerca de expresiones regulares para obtener pistas, al usar la notación de \'Respuesta corta de Moodle\'.';
$string['posix_class_outside_charset_node_error'] = 'clases POSIX no están permitidas fuera de conjuntos de caracteres';
$string['possessivequant'] = 'Cuantificadores posesivos';
$string['privacy:metadata'] = 'El tipo de pregunta Preg no almacena datos del usuario.';
$string['prune_leaf_control'] = '';
$string['quantifier_without_parameter_node_error'] = 'Error de sintaxis: cuantificador en posición desde {$a->colfirst} hastao {$a->collast} no tiene un operando - nada para repetir';
$string['questioneditingheading'] = 'Configuraciones para editar preguntas';
$string['recursion_leaf_assert'] = 'ficticio';
$string['recursion_node_cond_subexpr'] = 'subpatrón condicional recursivo';
$string['regex_handler'] = 'Manejador regex';
$string['set_unset_same_modifier_node_error'] = 'Activando y desactivando el modificador {$a->addinfo} al mismo tiempo en posición desde {$a->colfirst} hasta {$a->collast}';
$string['simplification_equivalences_full_1'] = 'Una aserción simple es superflua porque junato ya tiene lo mismo';
$string['simplification_equivalences_full_10'] = 'Las dos repeticiones anidadas pueden ser rempazadas por una';
$string['simplification_equivalences_full_11'] = 'Cuantificador "{$a->first}" equivalente "{$a->second}"';
$string['simplification_equivalences_full_12'] = 'Cuantificador "?" No puede ser removido como una alternativa puede ser el mismo vacío';
$string['simplification_equivalences_full_13'] = 'El vacío en la alternativa es superfluo porque la alternativa y siempre coincide con vacío';
$string['simplification_equivalences_full_14'] = 'El cuantificador no afecta la operación de la expresión regular, pueden ser removidos';
$string['simplification_equivalences_full_2'] = 'Los paréntesis vacíos no afectan la operación de una expresión regular, Usted puede eliminar';
$string['simplification_equivalences_full_2_1'] = 'Los paréntesis no afectan la operación de una expresión regular, Usted puede quitarlos';
$string['simplification_equivalences_full_3'] = 'Los paréntesis vacíos no afectan la operación de la expresión regular, ya que no tienen retroreferencia o subpatrón condicional, pueden ser eliminados';
$string['simplification_equivalences_full_3_1'] = 'Los paréntesis no afectan la operación de la expresión regular, ya que no tienen retroreferencia o subpatrón condicional, pueden ser removidos';
$string['simplification_equivalences_full_4'] = 'La parte recurrente de la expresión puede ser escrita en corto';
$string['simplification_equivalences_full_5'] = 'Los paréntesis cuadrados pueden quitarse porque lo incluido es solamente un caracter';
$string['simplification_equivalences_full_6'] = 'es mejor representado usando paréntesis cuadrados';
$string['simplification_equivalences_full_7'] = 'Usted puede hacer una %subexpresión% de los paréntesis';
$string['simplification_equivalences_full_8'] = 'Es más conveniente escribir usando el  "?"';
$string['simplification_equivalences_full_8_1'] = 'Vacío en la alternativa puede ser quitado, tal vez. Sin él podría concordar con vacío';
$string['simplification_equivalences_full_9'] = 'Usted puede quitar un cuantificador "?" Yo tengo una alternativa, añadiéndolo a una alternativa vacía';
$string['simplification_equivalences_short_1'] = 'Aserciones simples consecutivas';
$string['simplification_equivalences_short_10'] = 'Remplazo de dos cuantificadores uno';
$string['simplification_equivalences_short_11'] = 'Cambiando un cuantificador equivalente';
$string['simplification_equivalences_short_12'] = 'Cuantificador excesivo "?"';
$string['simplification_equivalences_short_13'] = 'Exceso de vacío en la alternativa';
$string['simplification_equivalences_short_14'] = 'El cuantificador inútil';
$string['simplification_equivalences_short_2'] = 'Los paréntesis vacíos "(?:)"';
$string['simplification_equivalences_short_2_1'] = 'Los paréntesis inútiles "(?:)"';
$string['simplification_equivalences_short_3'] = 'Paréntesis vacío "()"';
$string['simplification_equivalences_short_3_1'] = 'Los paréntesis inútiles"()"';
$string['simplification_equivalences_short_4'] = 'Sub-expresión recurrente';
$string['simplification_equivalences_short_5'] = 'Los paréntesis cuadrados extra';
$string['simplification_equivalences_short_6'] = 'Puede conducir hacia las clases de caracter equivalentes';
$string['simplification_equivalences_short_7'] = 'Introducción de subexpresiones alternativas';
$string['simplification_equivalences_short_8'] = 'Exceso de vacío en la alternativa';
$string['simplification_equivalences_short_8_1'] = 'Exceso de vacío en la alternativa';
$string['simplification_equivalences_short_9'] = 'Cuantificador excesivo "?"';
$string['simplification_errors_full_1'] = 'La aserción simple "^" es superflua, porque no está al principio de la expresión regular';
$string['simplification_errors_full_2'] = 'La aserción simple "$" es superflua, porque no está al final de la expresión regular';
$string['simplification_errors_short_1'] = 'Aserción simple excesiva "^"';
$string['simplification_errors_short_2'] = 'Aserción simple excesiva "$"';
$string['simplification_tips_full_1'] = 'Usted podría querer permitir cualquier espacio blanco (como un tabulador), Usted tiene que usar "\\s"';
$string['simplification_tips_full_2'] = 'Usted podría querer permitir cualquier número de caracteres de espacio blanco en este lugar, Usted tiene que usar un cuantificador "+"';
$string['simplification_tips_full_3'] = 'Los paréntesis le permiten a la concordancia recordar esta porción de la expresión. Si Usted no necesita los paréntesis, puede remplazarlos por el grupo "(?:)"';
$string['simplification_tips_full_4'] = 'Usted podría querer permitir cualquier número de caracteres de espacio blanco en este lugar, Usted tiene que usar el cuantificador  "*"';
$string['simplification_tips_full_5'] = 'La expresión concuerda con cualquier cadena de caracteres';
$string['simplification_tips_full_6'] = 'Tal vez quisiera ignorar MAY/minúsculas; entonces esto puede hacerse usando la opción de sensibilidad a MAY/minpusculas desactivada "(?i)"';
$string['simplification_tips_full_7'] = 'No copiar esta parte; Usted puede darle un nombre y llamar a otro lado';
$string['simplification_tips_full_8'] = 'Tal vez Usted debería de habilitar la "concordancia exacta" en lugar de "^" y "$" al principio y al final de la expresión';
$string['simplification_tips_full_8_alt'] = '"^" y "$" al principio y al final de la oración son superfluos,porque está habilitada "concordancia exacta"';
$string['simplification_tips_short_1'] = 'Expandir la lista de espacio_blanco';
$string['simplification_tips_short_2'] = 'Incrementar la lista de espacio_blanco';
$string['simplification_tips_short_3'] = 'Los paréntesis extra,para los cuales no hay retroreferencias';
$string['simplification_tips_short_4'] = 'Solamente un espacio_blanco';
$string['simplification_tips_short_5'] = 'La expresión coincide con vacío';
$string['simplification_tips_short_6'] = 'Usar opciónn (?i) en lugar de clase caracter con minúsculas y MAYÚSCULAS pareadas';
$string['simplification_tips_short_7'] = 'Uso repetido de la expresión';
$string['simplification_tips_short_8'] = 'Aserciones innecesarias izquierda y derecha';
$string['simplification_tool'] = 'Simplificación de expresión regular';
$string['simplification_tool_apply'] = 'Aplicar y siguiente';
$string['simplification_tool_cancel'] = 'Cancelar y siguiente';
$string['simplification_tool_equivalence'] = 'Equivalencias:';
$string['simplification_tool_error'] = 'Errores:';
$string['simplification_tool_help'] = 'Aquí puede Usted simplificar expresiones regulares si fuera necesario. Las sugerencias vienen en tres tipos: equivalencias (remplazo de la expresión por una expresión equivalente más óptima), sugerencias (incluir casos que podrían ser olvidados) y errores (casos en los que la expresión regular concuerda con cualquier cadena o que no concuerda con nada).';
$string['simplification_tool_tip'] = 'Sugerencias:';
$string['skip_leaf_control'] = '';
$string['skip_name_leaf_control'] = '';
$string['slash_at_end_of_pattern_node_error'] = 'Error de sintaxis: \\ al final del patrón';
$string['small_esc_z_leaf_assert'] = 'fin de la cadena';
$string['subexpr_leaf_assert'] = 'ficticio';
$string['subexpr_name_expected_node_error'] = 'Nombre de subpatrón esperado';
$string['subexpr_node_cond_subexpr'] = '"subpatrón"-subpatrón condicional';
$string['subexpr_node_subexpr'] = 'subexpresión';
$string['subexpression'] = 'Subexpresión';
$string['syntax_tree_tool'] = 'Árbol de sintaxis';
$string['syntax_tree_tool_collapsing_mode'] = 'Modo colapsante';
$string['syntax_tree_tool_help'] = 'Aquí puede ver el árbol de sintaxis de su expresión. Al presionar el nodo del árbol se marca el sub-árbol correspondiente, la sub-gráfica y la parte correspondiente de la descripción. Usted también puede colapsar / expander los nodos al activar el Modo colapsante.';
$string['then_leaf_control'] = '';
$string['tobecontinued'] = '...';
$string['too_large_fa'] = 'La expresión regular es demasiado compleja para ser concordada por  {$a->engine} debido a los límites de memoria o tiempo. Por favor intente otro motor para concordar, pídale a su administrador que  <a href="{$a->link}">aumente los límites de tiempo y memoria</a> o simplifique su expresión regular.';
$string['toolargequant'] = 'Cuantificador finito demasiado grande';
$string['toomanyerrors'] = '.......{$a} errores más';
$string['truefalse_leaf_assert'] = 'ficticio';
$string['typoanalysis'] = 'Análisis de errores tipográficos';
$string['typoanalysis_help'] = 'El Análisis de errores tipográficos asume que los estudiantes pueden tener errores dentro de la respuesta.';
$string['typosfound'] = 'Errores tipográficos encontrados';
$string['typospenalty'] = 'Penalización para cada error tipográfico';
$string['typospenalty_help'] = 'Penalización para cada error tipográfico';
$string['ucp_leaf_control'] = '';
$string['unallowedhint'] = 'La pista seleccionada no está permitida debido a restricciones en las configuraciones de la pregunta. Por favor, configure "Permitir pista {$a} Allow hinting" a "si (yes) " para permitirlot. El motor de concordancia seleccionado podría afectar la disponibilidad de pistas';
$string['unclosed_charset_node_error'] = 'Error de sintaxis: falta un paréntesis de cierre \']\' para el conjunto de caracteres que inicia en la posición {$a->colfirst}';
$string['unexisting_subexpr_node_error'] = 'El subpatrón "{$a->addinfo}" no existe';
$string['ungreedyquant'] = 'Cuantificadores no-codiciosos';
$string['unknown_control_sequence_node_error'] = 'Secuencia de control desconocida: {$a->addinfo}';
$string['unknown_error_node_error'] = 'Error desconocido';
$string['unknown_posix_class_node_error'] = 'Clase POSIX desconocida: {$a->addinfo}';
$string['unknown_template_node_error'] = 'Plantilla desconocida: {$a->addinfo}';
$string['unknown_unicode_property_node_error'] = 'Propiedad Unicode desconocida: {$a->addinfo}';
$string['unrecognized_pqh_node_error'] = 'Caracter no-reconocido después de (? o (?-';
$string['unrecognized_pqlt_node_error'] = 'Caracter no-reconocido después de (?<';
$string['unrecognized_pqp_node_error'] = 'Caracter no-reconocido después de (?P';
$string['unsupported'] = '{$a->nodename} en posición desde {$a->linefirst}:{$a->colfirst} hasta {$a->linelast}:{$a->collast} no está soportado por {$a->engine}.';
$string['unsupported_modifier_node_error'] = 'Modificador(es): {$a->addinfo} desconocido(s), equivocado(s) o no-soportado(s)';
$string['unsupportedmodifier'] = 'Error: el modificador {$a->modifier} no está soportado por el /la {$a->classname}.';
$string['usecharhint'] = 'Permitir pista siguiente letra';
$string['usecharhint_help'] = 'En comportamientos que permiten intentos múltiples (como por ejemplo, adaptativo o interactivo) se les muestra a los estudiantes el botón para \'Pista de la letra siguiente\' que les permite obtener una pista de una letra con la aplicación del \'Castigo por letra siguiente\'. No todos los motores de concordancia soportan el dar pistas.';
$string['usehint_help'] = 'En comportamientos que permiten intentos múltiples (como por ejemplo, adaptativo o interactivo) se les muestra a los estudiantes el botón para \'Pista de la letra siguiente\' que les permite obtener una pista de una letra con la aplicación del \'Castigo por letra siguiente\'. No todos los motores de concordancia soportan el dar pistas.';
$string['usehowtofixpichint'] = 'Permitir pista sobre como corregir (imagen)';
$string['usehowtofixpichint_help'] = 'Muestra al estudiante lo que debería hacer para hacer correcta la cadena de caracteres. El análisis de errores tipográficos y un límite de errores tipográficos arriba de 0 son requeridos.';
$string['uselexemhint'] = 'Permitir pista de lexema siguiente (palabra,número, signo de puntuación)';
$string['uselexemhint_help'] = '<p>En comportamientos que permiten intentos múltiples (por ejemplo, adaptativo o interactivo) mostrar a los estudiantes el botón para \'Pista palabra siguiente\' que les permite obtener una pista, ya sea completando el lexema actual o mostrando el siguiente si el lexema está completo al aplicar la \'Penalización por siguiente lexema\'. No todos los motores de concordancia soportan las pistas.</p><p><b>Lexema</b> es una parte anatómica del idioma/lenguaje : una palabra, número, signo de puntuación, operador, etc.</p>';
$string['utf16_leaf_control'] = '';
$string['utf8_leaf_control'] = '';
$string['wrong_template_params_count_node_error'] = 'Número equivocado de parámetros de plantilla: {$a->addinfo->expected} esperados, {$a->addinfo->given} dados';
